/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.dsl.api.ConfigResource;

@Story(value="Config Resources")
@Feature(value="Last modified")
public class ConfigResourceTestCase {
    @Test
    public void regularFileLastUpdated() throws URISyntaxException {
        URL resource = this.getClass().getResource("/simple_application.xml");
        long expected = new File(resource.toURI()).lastModified();
        ConfigResource configResource = new ConfigResource(resource);
        MatcherAssert.assertThat((Object)configResource.getLastModified(), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void jarResourceLastUpdated() throws IOException, URISyntaxException {
        URL resource = this.getClass().getResource("/simple_application.jar");
        long expected = new File(resource.toURI()).lastModified();
        try (URLClassLoader simpleApplicationJarClassLoader = new URLClassLoader(new URL[]{resource});){
            ConfigResource configResource = new ConfigResource(simpleApplicationJarClassLoader.getResource("simple_application_within_jar.xml"));
            MatcherAssert.assertThat((Object)configResource.getLastModified(), (Matcher)Is.is((Object)expected));
        }
    }

    @Test
    public void noUrlLastUpdated() {
        ConfigResource configResource = new ConfigResource("simple_application", (InputStream)Mockito.mock(InputStream.class));
        MatcherAssert.assertThat((Object)configResource.getLastModified(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void readTwice() throws IOException {
        URL resource = this.getClass().getResource("/simple_application.xml");
        ConfigResource configResource = new ConfigResource(resource);
        ByteArrayOutputStream firstRead = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)configResource.getInputStream(), (OutputStream)firstRead);
        ByteArrayOutputStream secondRead = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)configResource.getInputStream(), (OutputStream)secondRead);
        MatcherAssert.assertThat((Object)secondRead.toByteArray(), (Matcher)Is.is((Object)firstRead.toByteArray()));
    }
}

