/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xerces.xni.parser;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.apache.xerces.util.XMLResourceIdentifierImpl;
import org.mule.apache.xerces.xni.XMLResourceIdentifier;
import org.mule.apache.xerces.xni.grammars.Grammar;
import org.mule.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.mule.apache.xerces.xni.grammars.XMLGrammarPool;
import org.mule.apache.xerces.xni.parser.XMLEntityResolver;
import org.mule.apache.xerces.xni.parser.XMLInputSource;
import org.mule.runtime.dsl.api.xerces.xni.factories.XmlEntityResolverFactory;
import org.mule.runtime.dsl.api.xerces.xni.factories.XmlGathererErrorHandlerFactory;
import org.mule.runtime.dsl.internal.xerces.xni.parser.DefaultXmlGrammarPoolBuilder;
import org.mule.runtime.dsl.internal.xerces.xni.parser.ReadOnlyXmlGrammarPool;
import org.mule.runtime.dsl.internal.xerces.xni.parser.XmlGathererErrorHandler;
import org.mule.runtime.dsl.internal.xerces.xni.parser.XmlSchemaProvider;

@Feature(value="Mule DSL Parsing")
@Story(value="XML Grammar Pool")
public class DefaultXmlGrammarPoolBuilderTestCase {
    private static final Pair<String, String> COMPANY_XSD = Pair.of((Object)"http://www.mulesoft.org/schema/mule/fake-company/current/company.xsd", (Object)"META-INF/fake-company/company.xsd");
    private static final Pair<String, String> PERSON_XSD = Pair.of((Object)"http://www.mulesoft.org/schema/mule/fake-person/current/person.xsd", (Object)"META-INF/fake-company/person.xsd");
    private static final Pair<String, String> PRODUCT_XSD = Pair.of((Object)"http://www.mulesoft.org/schema/mule/fake-product/current/product.xsd", (Object)"META-INF/fake-company/product.xsd");
    private static final Pair<String, String> FAKE_XSD = Pair.of((Object)"http://www.mulesoft.org/schema/mule/core/current/mule-invalid-target.xsd", (Object)"META-INF/mule-unexisting-target.xsd");

    private XMLInputSource createXmlInputSource(Pair<String, String> schema) {
        return this.createXmlInputSource((String)schema.getLeft(), (String)schema.getRight());
    }

    private XMLInputSource createXmlInputSource(String systemId, String resourceLocation) {
        InputStream is = DefaultXmlGrammarPoolBuilderTestCase.class.getClassLoader().getResourceAsStream(resourceLocation);
        XMLResourceIdentifierImpl resourceIdentifier = new XMLResourceIdentifierImpl();
        resourceIdentifier.setPublicId(null);
        resourceIdentifier.setLiteralSystemId(systemId);
        resourceIdentifier.setBaseSystemId(null);
        XMLInputSource xis = new XMLInputSource((XMLResourceIdentifier)resourceIdentifier);
        xis.setByteStream(is);
        return xis;
    }

    @Test
    public void emptySchemaProviderShouldReturnEmptyGrammarPool() {
        XmlSchemaProvider emptySchemaProvider = (XmlSchemaProvider)Mockito.mock(XmlSchemaProvider.class);
        Mockito.when((Object)emptySchemaProvider.getSchemas()).thenReturn(new ArrayList());
        XmlGathererErrorHandler errorHandler = (XmlGathererErrorHandler)Mockito.mock(XmlGathererErrorHandler.class);
        XMLEntityResolver entityResolver = (XMLEntityResolver)Mockito.mock(XMLEntityResolver.class);
        DefaultXmlGrammarPoolBuilder builder = new DefaultXmlGrammarPoolBuilder(emptySchemaProvider, errorHandler, entityResolver);
        XMLGrammarPool xmlGrammarPool = builder.build();
        MatcherAssert.assertThat((Object)xmlGrammarPool, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)xmlGrammarPool, (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(ReadOnlyXmlGrammarPool.class)));
        Grammar[] grammars = xmlGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
        MatcherAssert.assertThat((Object)grammars, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)grammars.length, (Matcher)CoreMatchers.is((Object)0));
        grammars = xmlGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/TR/REC-xml");
        MatcherAssert.assertThat((Object)grammars.length, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void failureWhileCreatingXmlGrammarPoolShouldReturnEmptyGrammarPool() {
        XmlSchemaProvider emptySchemaProvider = (XmlSchemaProvider)Mockito.mock(XmlSchemaProvider.class);
        Mockito.when((Object)emptySchemaProvider.getSchemas()).thenThrow(new Throwable[]{new RuntimeException("Fake error")});
        XmlGathererErrorHandler errorHandler = (XmlGathererErrorHandler)Mockito.mock(XmlGathererErrorHandler.class);
        XMLEntityResolver entityResolver = (XMLEntityResolver)Mockito.mock(XMLEntityResolver.class);
        DefaultXmlGrammarPoolBuilder builder = new DefaultXmlGrammarPoolBuilder(emptySchemaProvider, errorHandler, entityResolver);
        XMLGrammarPool xmlGrammarPool = builder.build();
        MatcherAssert.assertThat((Object)xmlGrammarPool, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)xmlGrammarPool, (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(ReadOnlyXmlGrammarPool.class)));
        Grammar[] grammars = xmlGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
        MatcherAssert.assertThat((Object)grammars, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)grammars.length, (Matcher)CoreMatchers.is((Object)0));
        grammars = xmlGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/TR/REC-xml");
        MatcherAssert.assertThat((Object)grammars.length, (Matcher)CoreMatchers.is((Object)0));
        XMLGrammarDescription description = (XMLGrammarDescription)Mockito.mock(XMLGrammarDescription.class);
        Grammar grammar = xmlGrammarPool.retrieveGrammar(description);
        MatcherAssert.assertThat((Object)grammar, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void failureWhileParsingSchemasShouldReturnEmptyGrammarPool() {
        ArrayList<Pair<String, String>> schemas = new ArrayList<Pair<String, String>>();
        schemas.add(COMPANY_XSD);
        schemas.add(PERSON_XSD);
        schemas.add(PRODUCT_XSD);
        schemas.add(FAKE_XSD);
        XmlSchemaProvider emptySchemaProvider = (XmlSchemaProvider)Mockito.mock(XmlSchemaProvider.class);
        Mockito.when((Object)emptySchemaProvider.getSchemas()).thenReturn(schemas.stream().map(this::createXmlInputSource).collect(Collectors.toList()));
        XmlGathererErrorHandler errorHandler = XmlGathererErrorHandlerFactory.getDefault().create();
        XMLEntityResolver entityResolver = XmlEntityResolverFactory.getDefault().create();
        DefaultXmlGrammarPoolBuilder builder = new DefaultXmlGrammarPoolBuilder(emptySchemaProvider, errorHandler, entityResolver);
        XMLGrammarPool xmlGrammarPool = builder.build();
        MatcherAssert.assertThat((Object)xmlGrammarPool, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)xmlGrammarPool, (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(ReadOnlyXmlGrammarPool.class)));
        Grammar[] grammars = xmlGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
        MatcherAssert.assertThat((Object)grammars, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)grammars.length, (Matcher)CoreMatchers.is((Object)0));
        grammars = xmlGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/TR/REC-xml");
        MatcherAssert.assertThat((Object)grammars.length, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)errorHandler.getErrors().size(), (Matcher)CoreMatchers.is((Object)1));
        XMLGrammarDescription description = (XMLGrammarDescription)Mockito.mock(XMLGrammarDescription.class);
        Grammar grammar = xmlGrammarPool.retrieveGrammar(description);
        MatcherAssert.assertThat((Object)grammar, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void createXmlGrammarPool() {
        ArrayList<Pair<String, String>> schemas = new ArrayList<Pair<String, String>>();
        schemas.add(COMPANY_XSD);
        schemas.add(PERSON_XSD);
        schemas.add(PRODUCT_XSD);
        XmlSchemaProvider emptySchemaProvider = (XmlSchemaProvider)Mockito.mock(XmlSchemaProvider.class);
        Mockito.when((Object)emptySchemaProvider.getSchemas()).thenReturn(schemas.stream().map(this::createXmlInputSource).collect(Collectors.toList()));
        XmlGathererErrorHandler errorHandler = XmlGathererErrorHandlerFactory.getDefault().create();
        XMLEntityResolver entityResolver = XmlEntityResolverFactory.getDefault().create();
        DefaultXmlGrammarPoolBuilder builder = new DefaultXmlGrammarPoolBuilder(emptySchemaProvider, errorHandler, entityResolver);
        XMLGrammarPool xmlGrammarPool = builder.build();
        MatcherAssert.assertThat((Object)xmlGrammarPool, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)xmlGrammarPool, (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(ReadOnlyXmlGrammarPool.class)));
        Grammar[] grammars = xmlGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
        MatcherAssert.assertThat((Object)grammars, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)grammars.length, (Matcher)CoreMatchers.is((Object)3));
        grammars = xmlGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/TR/REC-xml");
        MatcherAssert.assertThat((Object)grammars.length, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)errorHandler.getErrors().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }
}

