/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xml.parser;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.dsl.internal.xml.parser.XmlMetadataAnnotations;

public class DefaultXmlMetadataAnnotations
implements XmlMetadataAnnotations {
    private static final Pattern COMPACT_PATTERN = Pattern.compile(">\\s+<+");
    public static final String METADATA_ANNOTATIONS_KEY = "metadataAnnotations";
    private static final Pattern URL_PATTERN = Pattern.compile("url=\"[a-z]*://([^@]*)@");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("address=\"[a-z]*://([^@]*)@");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("password=\"([^\"|\n]*)\"");
    private static final String PASSWORD_MASK = "@@credentials@@";
    private static final String PASSWORD_ATTRIBUTE_MASK = "password=\"%s\"";
    private final StringBuilder xmlContent = new StringBuilder();
    private int lineNumber;
    private int columnNumber;

    @Override
    public void appendElementStart(String qName, Map<String, String> atts) {
        this.xmlContent.append("<" + qName);
        for (Map.Entry<String, String> entry : atts.entrySet()) {
            this.xmlContent.append(DefaultXmlMetadataAnnotations.maskPasswords(" " + entry.getKey() + "=\"" + entry.getValue() + "\""));
        }
        this.xmlContent.append(">");
    }

    @Override
    public void appendElementBody(String elementBody) {
        this.xmlContent.append(elementBody);
    }

    @Override
    public void appendElementEnd(String qName) {
        this.xmlContent.append("</" + qName + ">");
    }

    @Override
    public String getElementString() {
        return COMPACT_PATTERN.matcher(this.xmlContent.toString().trim()).replaceAll(">" + System.lineSeparator() + "<");
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    private static String maskPasswords(String xml, String passwordMask) {
        xml = DefaultXmlMetadataAnnotations.maskUrlPassword(xml, URL_PATTERN, passwordMask);
        Matcher matcher = PASSWORD_PATTERN.matcher(xml = DefaultXmlMetadataAnnotations.maskUrlPassword(xml, ADDRESS_PATTERN, passwordMask));
        if (matcher.find() && matcher.groupCount() > 0) {
            xml = xml.replaceAll(Pattern.quote(DefaultXmlMetadataAnnotations.maskPasswordAttribute(matcher.group(1))), DefaultXmlMetadataAnnotations.maskPasswordAttribute(passwordMask));
        }
        xml = DefaultXmlMetadataAnnotations.maskUrlPassword(xml, PASSWORD_PATTERN, passwordMask);
        return xml;
    }

    private static String maskPasswords(String xml) {
        return DefaultXmlMetadataAnnotations.maskPasswords(xml, PASSWORD_MASK);
    }

    private static String maskUrlPassword(String xml, Pattern pattern, String passwordMask) {
        Matcher matcher = pattern.matcher(xml);
        if (matcher.find() && matcher.groupCount() > 0) {
            xml = xml.replaceAll(Pattern.quote(matcher.group(1)), passwordMask);
        }
        return xml;
    }

    private static String maskPasswordAttribute(String password) {
        return String.format(PASSWORD_ATTRIBUTE_MASK, password);
    }
}

