/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.util;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.dsl.internal.util.SchemaMappingsUtils;

@Feature(value="Mule DSL Parsing")
@Story(value="XML Grammar Pool")
public class SchemaMappingsUtilsTestCase {
    private static final String LEGACY_SPRING_XSD = "http://www.springframework.org/schema/beans/spring-beans-current.xsd";
    private static final String UNKNOW_XSD = "http://www.mulesoft.org/schema/mule/core/current/mule-unknow.xsd";

    @Test
    @Issue(value="MULE-16572")
    public void legacySpring() {
        String systemId = SchemaMappingsUtils.resolveSystemId((String)LEGACY_SPRING_XSD);
        MatcherAssert.assertThat((Object)systemId, (Matcher)CoreMatchers.is((Object)"http://www.springframework.org/schema/beans/spring-beans.xsd"));
    }

    @Test
    public void unknownSystemIdShouldNotBeResolved() {
        String systemId = SchemaMappingsUtils.resolveSystemId((String)UNKNOW_XSD);
        MatcherAssert.assertThat((Object)systemId, (Matcher)CoreMatchers.is((Object)systemId));
    }

    @Test
    public void coreCurrentXsdShouldBeResolved() {
        String systemId = SchemaMappingsUtils.resolveSystemId((String)"http://www.mulesoft.org/schema/mule/core/current/mule.xsd");
        MatcherAssert.assertThat((Object)systemId, (Matcher)CoreMatchers.is((Object)"http://www.mulesoft.org/schema/mule/core/current/mule-core.xsd"));
    }
}

