/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.DslSimpleType;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.mule.runtime.dsl.api.component.SetterAttributeDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class ComponentBuildingDefinition<T> {
    public static final String TYPE_CONVERTER_AND_UNKNOWN_TYPE_MESSAGE = "Type converter cannot be used with a type definition from a configuration attribute.";
    public static final String TYPE_CONVERTER_AND_NO_SIMPLE_TYPE_MESSAGE_TEMPLATE = "Type converter can only be used with simple types. You can't use it with %s";
    public static final String KEY_TYPE_CONVERTER_AND_NO_MAP_TYPE = "key type converter can only be used with objects of type Map";
    private TypeDefinition typeDefinition;
    private boolean scope;
    private List<AttributeDefinition> constructorAttributeDefinition = new ArrayList<AttributeDefinition>();
    private List<SetterAttributeDefinition> setterParameterDefinitions = new ArrayList<SetterAttributeDefinition>();
    private Set<String> ignoredConfigurationParameters = new HashSet<String>();
    private Class<? extends ObjectFactory<T>> objectFactoryType;
    private boolean prototype;
    private boolean named = false;
    private ComponentIdentifier componentIdentifier;
    private Optional<TypeConverter> typeConverter = Optional.empty();
    private Optional<TypeConverter> keyTypeConverter = Optional.empty();

    private ComponentBuildingDefinition() {
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean isScope() {
        return this.scope;
    }

    public List<AttributeDefinition> getConstructorAttributeDefinition() {
        return this.constructorAttributeDefinition;
    }

    public List<SetterAttributeDefinition> getSetterParameterDefinitions() {
        return this.setterParameterDefinitions;
    }

    public Set<String> getIgnoredConfigurationParameters() {
        return ImmutableSet.copyOf(this.ignoredConfigurationParameters);
    }

    public Class<? extends ObjectFactory<T>> getObjectFactoryType() {
        return this.objectFactoryType;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public Optional<TypeConverter> getTypeConverter() {
        return this.typeConverter;
    }

    public Optional<TypeConverter> getKeyTypeConverter() {
        return this.keyTypeConverter;
    }

    public boolean isNamed() {
        return this.named;
    }

    public List<AttributeDefinition> getAttributesDefinitions() {
        return Stream.concat(this.setterParameterDefinitions.stream().map(SetterAttributeDefinition::getAttributeDefinition), this.constructorAttributeDefinition.stream()).collect(Collectors.toList());
    }

    public static class Builder<T> {
        private String namespace;
        private String identifier;
        private ComponentBuildingDefinition<T> definition = new ComponentBuildingDefinition();

        public Builder<T> withConstructorParameterDefinition(AttributeDefinition attributeDefinition) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).constructorAttributeDefinition.add(attributeDefinition);
            return next;
        }

        public Builder<T> withSetterParameterDefinition(String fieldName, AttributeDefinition attributeDefinition) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).setterParameterDefinitions.add(new SetterAttributeDefinition(fieldName, attributeDefinition));
            return next;
        }

        public Builder<T> withIdentifier(String identifier) {
            Builder<T> next = this.copy();
            next.identifier = identifier;
            return next;
        }

        public Builder<T> withNamespace(String namespace) {
            Builder<T> next = this.copy();
            next.namespace = namespace;
            return next;
        }

        public Builder<T> withTypeDefinition(TypeDefinition<T> typeDefinition) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).typeDefinition = typeDefinition;
            return next;
        }

        public Builder<T> withTypeConverter(TypeConverter typeConverter) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).typeConverter = Optional.of(typeConverter);
            return next;
        }

        public Builder<T> withKeyTypeConverter(TypeConverter typeConverter) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).keyTypeConverter = Optional.of(typeConverter);
            return next;
        }

        public Builder<T> asScope() {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).scope = true;
            return next;
        }

        public Builder<T> asNamed() {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).named = true;
            return next;
        }

        public Builder<T> withObjectFactoryType(Class<? extends ObjectFactory<T>> objectFactoryType) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).objectFactoryType = objectFactoryType;
            return next;
        }

        public Builder<T> withIgnoredConfigurationParameter(String parameterName) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).ignoredConfigurationParameters.add(parameterName);
            return next;
        }

        private Builder<T> copy() {
            Builder<T> builder = new Builder<T>();
            ((ComponentBuildingDefinition)builder.definition).typeDefinition = ((ComponentBuildingDefinition)this.definition).typeDefinition;
            ((ComponentBuildingDefinition)builder.definition).setterParameterDefinitions = new ArrayList(((ComponentBuildingDefinition)this.definition).setterParameterDefinitions);
            ((ComponentBuildingDefinition)builder.definition).constructorAttributeDefinition = new ArrayList(((ComponentBuildingDefinition)this.definition).constructorAttributeDefinition);
            builder.identifier = this.identifier;
            builder.namespace = this.namespace;
            ((ComponentBuildingDefinition)builder.definition).prototype = ((ComponentBuildingDefinition)this.definition).prototype;
            ((ComponentBuildingDefinition)builder.definition).scope = ((ComponentBuildingDefinition)this.definition).scope;
            ((ComponentBuildingDefinition)builder.definition).typeDefinition = ((ComponentBuildingDefinition)this.definition).typeDefinition;
            ((ComponentBuildingDefinition)builder.definition).objectFactoryType = ((ComponentBuildingDefinition)this.definition).objectFactoryType;
            if (this.definition.isNamed()) {
                ((ComponentBuildingDefinition)builder.definition).named = true;
            }
            return builder;
        }

        public ComponentBuildingDefinition<T> build() {
            Preconditions.checkState((((ComponentBuildingDefinition)this.definition).typeDefinition != null ? 1 : 0) != 0, (Object)"You must specify the type");
            Preconditions.checkState((this.identifier != null ? 1 : 0) != 0, (Object)"You must specify the identifier");
            Preconditions.checkState((this.namespace != null ? 1 : 0) != 0, (Object)"You must specify the namespace");
            Optional<Class> componentType = this.getType();
            Preconditions.checkState((!((ComponentBuildingDefinition)this.definition).typeConverter.isPresent() || ((ComponentBuildingDefinition)this.definition).typeConverter.isPresent() && componentType.isPresent() ? 1 : 0) != 0, (Object)ComponentBuildingDefinition.TYPE_CONVERTER_AND_UNKNOWN_TYPE_MESSAGE);
            Preconditions.checkState((!((ComponentBuildingDefinition)this.definition).typeConverter.isPresent() || ((ComponentBuildingDefinition)this.definition).typeConverter.isPresent() && (DslSimpleType.isSimpleType(componentType.get()) || this.isMapType(componentType.get())) ? 1 : 0) != 0, (Object)String.format(ComponentBuildingDefinition.TYPE_CONVERTER_AND_NO_SIMPLE_TYPE_MESSAGE_TEMPLATE, componentType.orElse(Object.class).getName()));
            Preconditions.checkState((!((ComponentBuildingDefinition)this.definition).keyTypeConverter.isPresent() || ((ComponentBuildingDefinition)this.definition).keyTypeConverter.isPresent() && componentType.isPresent() && this.isMapType(componentType.get()) ? 1 : 0) != 0, (Object)ComponentBuildingDefinition.KEY_TYPE_CONVERTER_AND_NO_MAP_TYPE);
            ((ComponentBuildingDefinition)this.definition).componentIdentifier = ComponentIdentifier.builder().name(this.identifier).namespace(this.namespace).build();
            return this.definition;
        }

        private boolean isMapType(Class componentType) {
            return Map.class.isAssignableFrom(componentType);
        }

        public Builder<T> asPrototype() {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).prototype = true;
            return next;
        }

        private Optional<Class> getType() {
            final AtomicReference typeReference = new AtomicReference();
            ((ComponentBuildingDefinition)this.definition).typeDefinition.visit(new TypeDefinitionVisitor(){

                @Override
                public void onType(Class<?> type) {
                    typeReference.set(type);
                }

                @Override
                public void onConfigurationAttribute(String attributeName, Class<?> enforcedClass) {
                }

                @Override
                public void onMapType(TypeDefinition.MapEntryType mapEntryType) {
                    typeReference.set(Map.class);
                }
            });
            return Optional.ofNullable(typeReference.get());
        }
    }
}

