/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class TypeDefinition<T> {
    private Class<T> type;
    private String attributeName;
    private MapEntryType mapType;
    private Class<?> inforcedClass;

    private TypeDefinition() {
    }

    public static <T> TypeDefinition<T> fromType(Class<T> type) {
        TypeDefinition<T> typeDefinition = new TypeDefinition<T>();
        typeDefinition.type = type;
        return typeDefinition;
    }

    public static <T> TypeDefinition<T> fromConfigurationAttribute(String configAttributeName) {
        TypeDefinition<T> typeDefinition = new TypeDefinition<T>();
        typeDefinition.attributeName = configAttributeName;
        return typeDefinition;
    }

    public TypeDefinition<T> checkingThatIsClassOrInheritsFrom(Class<?> inforcedClass) {
        this.inforcedClass = inforcedClass;
        return this;
    }

    public void visit(TypeDefinitionVisitor typeDefinitionVisitor) {
        if (this.type != null) {
            typeDefinitionVisitor.onType(this.type);
        } else if (this.mapType != null) {
            typeDefinitionVisitor.onMapType(this.mapType);
        } else if (this.inforcedClass != null) {
            typeDefinitionVisitor.onConfigurationAttribute(this.attributeName, this.inforcedClass);
        } else {
            typeDefinitionVisitor.onConfigurationAttribute(this.attributeName, Object.class);
        }
    }

    public static <T, K, V> TypeDefinition<T> fromMapEntryType(Class<K> keyType, Class<V> valueType) {
        TypeDefinition<T> typeDefinition = new TypeDefinition<T>();
        typeDefinition.mapType = new MapEntryType<K, V>(keyType, valueType);
        return typeDefinition;
    }

    public static class MapEntryType<KeyType, ValueType> {
        private Class<KeyType> keyType;
        private Class<ValueType> valueType;

        public MapEntryType(Class<KeyType> keyType, Class<ValueType> valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public Class<?> getKeyType() {
            return this.keyType;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }
    }
}

