/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.DslSimpleType;
import org.mule.runtime.dsl.api.component.SetterAttributeDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class ComponentBuildingDefinition {
    public static final String TYPE_CONVERTER_AND_UNKNOWN_TYPE_MESSAGE = "Type converter cannot be used with a type definition from a configuration attribute.";
    public static final String TYPE_CONVERTER_AND_NO_SIMPLE_TYPE_MESSAGE_TEMPLATE = "Type converter can only be used with simple types. You can't use it with %s";
    public static final String KEY_TYPE_CONVERTER_AND_NO_MAP_TYPE = "key type converter can only be used with objects of type Map";
    private TypeDefinition typeDefinition;
    private boolean scope;
    private List<AttributeDefinition> constructorAttributeDefinition = new ArrayList<AttributeDefinition>();
    private List<SetterAttributeDefinition> setterParameterDefinitions = new ArrayList<SetterAttributeDefinition>();
    private Set<String> ignoredConfigurationParameters = new HashSet<String>();
    private Class<?> objectFactoryType;
    private boolean prototype;
    private boolean named = false;
    private ComponentIdentifier componentIdentifier;
    private Optional<TypeConverter> typeConverter = Optional.empty();
    private Optional<TypeConverter> keyTypeConverter = Optional.empty();

    private ComponentBuildingDefinition() {
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean isScope() {
        return this.scope;
    }

    public List<AttributeDefinition> getConstructorAttributeDefinition() {
        return this.constructorAttributeDefinition;
    }

    public List<SetterAttributeDefinition> getSetterParameterDefinitions() {
        return this.setterParameterDefinitions;
    }

    public Set<String> getIgnoredConfigurationParameters() {
        return ImmutableSet.copyOf(this.ignoredConfigurationParameters);
    }

    public Class<?> getObjectFactoryType() {
        return this.objectFactoryType;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public Optional<TypeConverter> getTypeConverter() {
        return this.typeConverter;
    }

    public Optional<TypeConverter> getKeyTypeConverter() {
        return this.keyTypeConverter;
    }

    public boolean isNamed() {
        return this.named;
    }

    public List<AttributeDefinition> getAttributesDefinitions() {
        return Stream.concat(this.setterParameterDefinitions.stream().map(SetterAttributeDefinition::getAttributeDefinition), this.constructorAttributeDefinition.stream()).collect(Collectors.toList());
    }

    public static class Builder {
        private String namespace;
        private String identifier;
        private ComponentBuildingDefinition definition = new ComponentBuildingDefinition();

        public Builder withConstructorParameterDefinition(AttributeDefinition attributeDefinition) {
            this.definition.constructorAttributeDefinition.add(attributeDefinition);
            return this;
        }

        public Builder withSetterParameterDefinition(String fieldName, AttributeDefinition attributeDefinition) {
            this.definition.setterParameterDefinitions.add(new SetterAttributeDefinition(fieldName, attributeDefinition));
            return this;
        }

        public Builder withIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder withNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder withTypeDefinition(TypeDefinition typeDefinition) {
            this.definition.typeDefinition = typeDefinition;
            return this;
        }

        public Builder withTypeConverter(TypeConverter typeConverter) {
            this.definition.typeConverter = Optional.of(typeConverter);
            return this;
        }

        public Builder withKeyTypeConverter(TypeConverter typeConverter) {
            this.definition.keyTypeConverter = Optional.of(typeConverter);
            return this;
        }

        public Builder asScope() {
            this.definition.scope = true;
            return this;
        }

        public Builder asNamed() {
            this.definition.named = true;
            return this;
        }

        public Builder withObjectFactoryType(Class<?> objectFactoryType) {
            this.definition.objectFactoryType = objectFactoryType;
            return this;
        }

        public Builder withIgnoredConfigurationParameter(String parameterName) {
            this.definition.ignoredConfigurationParameters.add(parameterName);
            return this;
        }

        public Builder copy() {
            Builder builder = new Builder();
            builder.definition.typeDefinition = this.definition.typeDefinition;
            builder.definition.setterParameterDefinitions = new ArrayList(this.definition.setterParameterDefinitions);
            builder.definition.constructorAttributeDefinition = new ArrayList(this.definition.constructorAttributeDefinition);
            builder.identifier = this.identifier;
            builder.namespace = this.namespace;
            builder.definition.prototype = this.definition.prototype;
            builder.definition.scope = this.definition.scope;
            builder.definition.typeDefinition = this.definition.typeDefinition;
            builder.definition.objectFactoryType = this.definition.objectFactoryType;
            if (this.definition.isNamed()) {
                builder.asNamed();
            }
            return builder;
        }

        public ComponentBuildingDefinition build() {
            Preconditions.checkState((this.definition.typeDefinition != null ? 1 : 0) != 0, (Object)"You must specify the type");
            Preconditions.checkState((this.identifier != null ? 1 : 0) != 0, (Object)"You must specify the identifier");
            Preconditions.checkState((this.namespace != null ? 1 : 0) != 0, (Object)"You must specify the namespace");
            Optional<Class> componentType = this.getType();
            Preconditions.checkState((!this.definition.typeConverter.isPresent() || this.definition.typeConverter.isPresent() && componentType.isPresent() ? 1 : 0) != 0, (Object)ComponentBuildingDefinition.TYPE_CONVERTER_AND_UNKNOWN_TYPE_MESSAGE);
            Preconditions.checkState((!this.definition.typeConverter.isPresent() || this.definition.typeConverter.isPresent() && (DslSimpleType.isSimpleType(componentType.get()) || this.isMapType(componentType.get())) ? 1 : 0) != 0, (Object)String.format(ComponentBuildingDefinition.TYPE_CONVERTER_AND_NO_SIMPLE_TYPE_MESSAGE_TEMPLATE, componentType.orElse(Object.class).getName()));
            Preconditions.checkState((!this.definition.keyTypeConverter.isPresent() || this.definition.keyTypeConverter.isPresent() && componentType.isPresent() && this.isMapType(componentType.get()) ? 1 : 0) != 0, (Object)ComponentBuildingDefinition.KEY_TYPE_CONVERTER_AND_NO_MAP_TYPE);
            this.definition.componentIdentifier = ComponentIdentifier.builder().withName(this.identifier).withNamespace(this.namespace).build();
            return this.definition;
        }

        private boolean isMapType(Class componentType) {
            return Map.class.isAssignableFrom(componentType);
        }

        public Builder asPrototype() {
            this.definition.prototype = true;
            return this;
        }

        private Optional<Class> getType() {
            final AtomicReference typeReference = new AtomicReference();
            this.definition.typeDefinition.visit(new TypeDefinitionVisitor(){

                @Override
                public void onType(Class<?> type) {
                    typeReference.set(type);
                }

                @Override
                public void onConfigurationAttribute(String attributeName) {
                }

                @Override
                public void onMapType(TypeDefinition.MapEntryType mapEntryType) {
                    typeReference.set(Map.class);
                }
            });
            return Optional.ofNullable(typeReference.get());
        }
    }
}

