/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainFactory;
import org.mule.runtime.module.deployment.internal.MuleDeploymentService;
import org.mule.runtime.module.deployment.internal.singleapp.SingleAppApplicationDeployerBuilder;
import org.mule.runtime.module.deployment.internal.singleapp.SingleAppDeploymentFileResolver;
import org.mule.runtime.module.deployment.internal.singleapp.SingleAppDeploymentService;
import org.mule.runtime.module.deployment.internal.singleapp.SingleAppDomainDeployerBuilder;
import org.mule.runtime.module.deployment.internal.singleapp.WriteToRouteTerminationHandler;

public class DeploymentServiceBuilder {
    public static final String DOMAIN_FACTORY_IS_NULL_ERROR_MESSAGE = "Domain Factory is null";
    public static final String APPLICATION_FACTORY_IS_NULL_ERROR_MESSAGE = "Application Factory is null";
    public static final String ARTIFACT_START_EXECUTOR_SUPPLIER_IS_NULL_ERROR_MESSAGE = "Artifact Start Executor Supplier is null";
    private DefaultDomainFactory domainFactory;
    private DefaultApplicationFactory applicationFactory;
    private Supplier<SchedulerService> artifactStartExecutorSupplier;
    private Consumer<Throwable> deploymentFailureThrowableConsumer = t -> {};

    private DeploymentServiceBuilder() {
    }

    public static DeploymentServiceBuilder deploymentServiceBuilder() {
        return new DeploymentServiceBuilder();
    }

    public DeploymentServiceBuilder withDomainFactory(DefaultDomainFactory domainFactory) {
        this.domainFactory = domainFactory;
        return this;
    }

    public DeploymentServiceBuilder withApplicationFactory(DefaultApplicationFactory applicationFactory) {
        this.applicationFactory = applicationFactory;
        return this;
    }

    public DeploymentServiceBuilder withArtifactStartExecutorSupplier(Supplier<SchedulerService> artifactStartExecutorSupplier) {
        this.artifactStartExecutorSupplier = artifactStartExecutorSupplier;
        return this;
    }

    public DeploymentServiceBuilder withDeploymentFailureThrowableConsumer(Consumer<Throwable> deploymentFailureThrowableConsumer) {
        this.deploymentFailureThrowableConsumer = deploymentFailureThrowableConsumer;
        return this;
    }

    public DeploymentService build() {
        Objects.requireNonNull(this.domainFactory, DOMAIN_FACTORY_IS_NULL_ERROR_MESSAGE);
        Objects.requireNonNull(this.applicationFactory, APPLICATION_FACTORY_IS_NULL_ERROR_MESSAGE);
        Objects.requireNonNull(this.artifactStartExecutorSupplier, ARTIFACT_START_EXECUTOR_SUPPLIER_IS_NULL_ERROR_MESSAGE);
        if (Boolean.getBoolean("mule.single.app.mode")) {
            SingleAppDomainDeployerBuilder singleAppDomainDeployerBuilder = SingleAppDomainDeployerBuilder.getSingleAppDomainDeployerBuilder();
            singleAppDomainDeployerBuilder.withDomainFactory(this.domainFactory).withApplicationFactory(this.applicationFactory);
            SingleAppApplicationDeployerBuilder singleAppApplicationDeployerBuilder = SingleAppApplicationDeployerBuilder.getSingleAppApplicationDeployerBuilder();
            singleAppApplicationDeployerBuilder.withApplicationFactory(this.applicationFactory);
            SingleAppDeploymentService deploymentService = new SingleAppDeploymentService(singleAppDomainDeployerBuilder, singleAppApplicationDeployerBuilder, new SingleAppDeploymentFileResolver(), new ArrayList<Application>(), new ArrayList<Domain>(), this.artifactStartExecutorSupplier);
            deploymentService.onDeploymentError(new WriteToRouteTerminationHandler(this.deploymentFailureThrowableConsumer));
            return deploymentService;
        }
        return new MuleDeploymentService(this.domainFactory, this.applicationFactory, this.artifactStartExecutorSupplier);
    }
}

