/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.module.deployment.internal.ActionTask;
import org.mule.runtime.module.deployment.internal.Log4jWrapperNativeLibrariesFolderDeletionRetryScheduledTaskLogger;
import org.mule.runtime.module.deployment.internal.NativeLibrariesFolderDeletionRetryScheduledTaskLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibrariesFolderDeletionRetryScheduledTask
implements Runnable,
ActionTask {
    private final ScheduledExecutorService scheduler;
    private final int maxAttempts;
    private final AtomicInteger attempts;
    private final ActionTask actionTask;
    private final NativeLibrariesFolderDeletionRetryScheduledTaskLogger logger;
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeLibrariesFolderDeletionRetryScheduledTask.class);
    private static final boolean DISABLE_NATIVE_LIBRARIES_FOLDER_DELETION_GC_CALL = Boolean.parseBoolean(System.getProperty("mule.disable.nativeLibrariesFolderDeletion.gc.call", "false"));

    public NativeLibrariesFolderDeletionRetryScheduledTask(ScheduledExecutorService scheduler, int maxAttempts, ActionTask actionTask, NativeLibrariesFolderDeletionRetryScheduledTaskLogger logger) {
        this.scheduler = scheduler;
        this.maxAttempts = maxAttempts;
        this.attempts = new AtomicInteger(0);
        this.actionTask = actionTask;
        this.logger = logger;
    }

    public NativeLibrariesFolderDeletionRetryScheduledTask(ScheduledExecutorService scheduler, int maxAttempts, ActionTask actionTask) {
        this(scheduler, maxAttempts, actionTask, new Log4jWrapperNativeLibrariesFolderDeletionRetryScheduledTaskLogger(LOGGER));
    }

    @Override
    public void run() {
        boolean secondToLastAttempt;
        int attempt = this.attempts.incrementAndGet();
        boolean bl = secondToLastAttempt = attempt == this.maxAttempts - 1;
        if (!DISABLE_NATIVE_LIBRARIES_FOLDER_DELETION_GC_CALL && secondToLastAttempt) {
            System.gc();
            this.logger.debug("Attempt {}. System.gc() executed.", attempt);
        }
        if (this.tryAction()) {
            this.scheduler.shutdown();
        } else if (attempt >= this.maxAttempts) {
            this.logger.error("Failed to perform the action. No further retries will be made.", new Object[0]);
            this.scheduler.shutdown();
        } else {
            this.logger.warn("Attempt {}. Failed to perform the action. Retrying...", attempt);
        }
    }

    @Override
    public boolean tryAction() {
        return this.actionTask.tryAction();
    }
}

