/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.container.internal.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DeploymentUtils;
import org.mule.runtime.module.deployment.internal.DomainBundleArchiveDeployer;
import org.mule.runtime.module.deployment.internal.util.DebuggableReentrantLock;
import org.mule.runtime.module.deployment.internal.util.ElementAddedEvent;
import org.mule.runtime.module.deployment.internal.util.ElementRemovedEvent;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentDirectoryWatcher
implements Runnable {
    public static final String ARTIFACT_ANCHOR_SUFFIX = "-anchor.txt";
    public static final String CHANGE_CHECK_INTERVAL_PROPERTY = "mule.launcher.changeCheckInterval";
    public static final IOFileFilter JAR_ARTIFACT_FILTER = new AndFileFilter((IOFileFilter)new SuffixFileFilter(".jar", IOCase.INSENSITIVE), FileFileFilter.FILE);
    public static final IOFileFilter ZIP_ARTIFACT_FILTER = new AndFileFilter((IOFileFilter)new SuffixFileFilter(".zip", IOCase.INSENSITIVE), FileFileFilter.FILE);
    protected static final int DEFAULT_CHANGES_CHECK_INTERVAL_MS = 5000;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentDirectoryWatcher.class);
    private static final Logger SPLASH_LOGGER = LoggerFactory.getLogger((String)"org.mule.runtime.core.internal.logging");
    private final ReentrantLock deploymentLock;
    private final ArchiveDeployer<DomainDescriptor, Domain> domainArchiveDeployer;
    protected final ArchiveDeployer<ApplicationDescriptor, Application> applicationArchiveDeployer;
    protected final Supplier<SchedulerService> schedulerServiceSupplier;
    private final ArtifactTimestampListener<Application> applicationTimestampListener;
    private final ArtifactTimestampListener<Domain> domainTimestampListener;
    private final ObservableList<Application> applications;
    private final ObservableList<Domain> domains;
    private final DomainBundleArchiveDeployer domainBundleDeployer;
    private final File appsDir;
    private final File domainsDir;
    private final boolean disposeArtifactsOnStop;
    private Scheduler artifactDirMonitorScheduler;
    protected volatile boolean dirty;

    public DeploymentDirectoryWatcher(DomainBundleArchiveDeployer domainBundleDeployer, ArchiveDeployer<DomainDescriptor, Domain> domainArchiveDeployer, ArchiveDeployer<ApplicationDescriptor, Application> applicationArchiveDeployer, ObservableList<Domain> domains, ObservableList<Application> applications, Supplier<SchedulerService> schedulerServiceSupplier, ReentrantLock deploymentLock) {
        this(domainBundleDeployer, domainArchiveDeployer, applicationArchiveDeployer, domains, applications, schedulerServiceSupplier, deploymentLock, true);
    }

    public DeploymentDirectoryWatcher(DomainBundleArchiveDeployer domainBundleDeployer, ArchiveDeployer<DomainDescriptor, Domain> domainArchiveDeployer, ArchiveDeployer<ApplicationDescriptor, Application> applicationArchiveDeployer, ObservableList<Domain> domains, ObservableList<Application> applications, Supplier<SchedulerService> schedulerServiceSupplier, ReentrantLock deploymentLock, boolean disposeArtifactsOnStop) {
        this.disposeArtifactsOnStop = disposeArtifactsOnStop;
        this.domainBundleDeployer = domainBundleDeployer;
        this.appsDir = applicationArchiveDeployer.getDeploymentDirectory();
        this.domainsDir = domainArchiveDeployer.getDeploymentDirectory();
        this.deploymentLock = deploymentLock;
        this.domainArchiveDeployer = domainArchiveDeployer;
        this.applicationArchiveDeployer = applicationArchiveDeployer;
        this.applications = applications;
        this.domains = domains;
        applications.addPropertyChangeListener(e -> {
            if (e instanceof ElementAddedEvent || e instanceof ElementRemovedEvent) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Deployed applications set has been modified, flushing state.");
                }
                this.dirty = true;
            }
        });
        domains.addPropertyChangeListener(e -> {
            if (e instanceof ElementAddedEvent || e instanceof ElementRemovedEvent) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Deployed applications set has been modified, flushing state.");
                }
                this.dirty = true;
            }
        });
        this.schedulerServiceSupplier = schedulerServiceSupplier;
        this.applicationTimestampListener = new ArtifactTimestampListener<Application>(applications);
        this.domainTimestampListener = new ArtifactTimestampListener<Domain>(domains);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.deploymentLock.lock();
        this.deleteAllAnchors();
        String appString = System.getProperty("mule.deploy.applications");
        try {
            if (appString == null) {
                this.run();
                this.scheduleChangeMonitor();
            } else {
                String[] explodedDomains = DeploymentUtils.listFiles(this.domainsDir, (FilenameFilter)DirectoryFileFilter.DIRECTORY);
                String[] packagedDomains = DeploymentUtils.listFiles(this.domainsDir, (FilenameFilter)JAR_ARTIFACT_FILTER);
                this.deployPackedDomains(packagedDomains);
                DeploymentUtils.deployExplodedDomains(this.domainArchiveDeployer, explodedDomains);
                String[] apps = appString.split(":");
                for (String app : apps = this.removeDuplicateAppNames(apps)) {
                    try {
                        File applicationFile = new File(this.appsDir, app + ".jar");
                        if (applicationFile.exists() && applicationFile.isFile()) {
                            this.applicationArchiveDeployer.deployPackagedArtifact(app + ".jar", Optional.empty());
                            continue;
                        }
                        if (!this.applicationArchiveDeployer.isUpdatedZombieArtifact(app)) continue;
                        this.applicationArchiveDeployer.deployExplodedArtifact(app, Optional.empty());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                SPLASH_LOGGER.info(SplashScreen.miniSplash((String)"Mule is up and running in a fixed app set mode"));
            }
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    public void stop() {
        this.stop(this.disposeArtifactsOnStop);
    }

    public void stop(boolean disposeArtifacts) {
        this.stopAppDirMonitorTimer();
        if (disposeArtifacts) {
            this.deploymentLock.lock();
            try {
                this.setDoNotPersistStopStatusOfArtifacts();
                this.stopArtifacts(this.applications);
                this.stopArtifacts(this.domains);
            }
            finally {
                this.deploymentLock.unlock();
            }
        }
    }

    private void stopArtifacts(List<? extends DeployableArtifact> artifacts) {
        Collections.reverse(artifacts);
        for (DeployableArtifact deployableArtifact : artifacts) {
            try {
                deployableArtifact.stop();
                deployableArtifact.dispose();
            }
            catch (Throwable t) {
                logger.error("Error stopping artifact {}", (Object)deployableArtifact.getArtifactName(), (Object)t);
            }
        }
    }

    static int getChangesCheckIntervalMs() {
        try {
            String value = System.getProperty(CHANGE_CHECK_INTERVAL_PROPERTY);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 5000;
        }
    }

    private void scheduleChangeMonitor() {
        int reloadIntervalMs = DeploymentDirectoryWatcher.getChangesCheckIntervalMs();
        SchedulerConfig schedulerConfig = SchedulerConfig.config().withName("Mule.app.deployer.monitor").withPriority(1).withMaxConcurrentTasks(1);
        this.artifactDirMonitorScheduler = this.schedulerServiceSupplier.get().customScheduler(schedulerConfig);
        this.artifactDirMonitorScheduler.scheduleWithFixedDelay((Runnable)this, (long)reloadIntervalMs, (long)reloadIntervalMs, TimeUnit.MILLISECONDS);
        SPLASH_LOGGER.info(SplashScreen.miniSplash((String)String.format("Mule is up and kicking (every %dms)", reloadIntervalMs)));
    }

    protected void deployPackedApps(String[] zips) {
        for (String zip : zips) {
            try {
                String artifactName = StringUtils.removeEndIgnoreCase((String)zip, (String)".jar");
                Optional deploymentProperties = DeploymentPropertiesUtils.getPersistedDeploymentProperties((String)artifactName);
                this.applicationArchiveDeployer.deployPackagedArtifact(zip, (Optional<Properties>)deploymentProperties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void deployExplodedApps(String[] apps) {
        for (String addedApp : apps) {
            try {
                Optional deploymentProperties = DeploymentPropertiesUtils.getPersistedDeploymentProperties((String)addedApp);
                this.applicationArchiveDeployer.deployExplodedArtifact(addedApp, deploymentProperties);
            }
            catch (DeploymentException deploymentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Checking for changes...");
            }
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Another deployment operation in progress, will skip this cycle. Owner thread: " + String.valueOf(((DebuggableReentrantLock)this.deploymentLock).getOwner()));
                }
                return;
            }
            this.undeployRemovedApps();
            this.undeployRemovedDomains();
            this.deployDomainBundles();
            String[] domains = DeploymentUtils.listFiles(this.domainsDir, (FilenameFilter)DirectoryFileFilter.DIRECTORY);
            String[] domainZips = DeploymentUtils.listFiles(this.domainsDir, (FilenameFilter)JAR_ARTIFACT_FILTER);
            this.redeployModifiedDomains();
            this.deployPackedDomains(domainZips);
            if (domainZips.length > 0 || this.dirty) {
                domains = DeploymentUtils.listFiles(this.domainsDir, (FilenameFilter)DirectoryFileFilter.DIRECTORY);
            }
            DeploymentUtils.deployExplodedDomains(this.domainArchiveDeployer, domains);
            this.redeployModifiedApplications();
            Object[] apps = DeploymentUtils.listFiles(this.appsDir, (FilenameFilter)DirectoryFileFilter.DIRECTORY);
            String[] appZips = DeploymentUtils.listFiles(this.appsDir, (FilenameFilter)JAR_ARTIFACT_FILTER);
            this.deployPackedApps(appZips);
            if (appZips.length > 0 || this.dirty) {
                apps = DeploymentUtils.listFiles(this.appsDir, (FilenameFilter)DirectoryFileFilter.DIRECTORY);
            }
            Arrays.sort(apps);
            this.deployExplodedApps((String[])apps);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            } else {
                logger.error("Exception processing deployment watch dir.", (Throwable)e);
            }
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
            this.dirty = false;
        }
    }

    private void deployDomainBundles() {
        String[] domainBundles;
        for (String domainBundle : domainBundles = DeploymentUtils.listFiles(this.domainsDir, (FilenameFilter)ZIP_ARTIFACT_FILTER)) {
            try {
                File domainBundleFile = new File(MuleFoldersUtil.getDomainsFolder(), domainBundle);
                this.domainBundleDeployer.deployArtifact(domainBundleFile.toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public <D extends DeployableArtifactDescriptor, T extends Artifact<D>> T findArtifact(String artifactName, ObservableList<T> artifacts) {
        return (T)((Artifact)artifacts.stream().filter(artifact -> artifact.getArtifactName().equals(artifactName)).findFirst().orElse(null));
    }

    private void undeployRemovedDomains() {
        this.undeployRemovedArtifacts(this.domainsDir, this.domains, this.domainArchiveDeployer);
    }

    private void undeployRemovedApps() {
        this.undeployRemovedArtifacts(this.appsDir, this.applications, this.applicationArchiveDeployer);
    }

    private <D extends DeployableArtifactDescriptor> void undeployRemovedArtifacts(File artifactDir, ObservableList<? extends Artifact<D>> artifacts, ArchiveDeployer<D, ? extends Artifact<D>> archiveDeployer) {
        String[] currentAnchors = DeploymentUtils.listFiles(artifactDir, (FilenameFilter)new SuffixFileFilter(ARTIFACT_ANCHOR_SUFFIX));
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Current anchors:%n", new Object[0]));
            for (String currentAnchor : currentAnchors) {
                sb.append(String.format("  %s%n", currentAnchor));
            }
            logger.debug(sb.toString());
        }
        Set currentAnchorsSet = Arrays.stream(currentAnchors).collect(Collectors.toSet());
        Collection deletedAnchors = Arrays.stream(this.findExpectedAnchorFiles(artifacts)).filter(a -> !currentAnchorsSet.contains(a)).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Deleted anchors:%n", new Object[0]));
            for (String deletedAnchor : deletedAnchors) {
                sb.append(String.format("  %s%n", deletedAnchor));
            }
            logger.debug(sb.toString());
        }
        for (String deletedAnchor : deletedAnchors) {
            String artifactName = StringUtils.removeEnd((String)deletedAnchor, (String)ARTIFACT_ANCHOR_SUFFIX);
            try {
                if (this.findArtifact(artifactName, artifacts) != null) {
                    archiveDeployer.undeployArtifact(artifactName);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("Artifact [%s] has already been undeployed via API", artifactName));
            }
            catch (Throwable t) {
                logger.error("Failed to undeployArtifact artifact: " + artifactName, t);
            }
        }
    }

    private <D extends DeployableArtifactDescriptor> String[] findExpectedAnchorFiles(ObservableList<? extends Artifact<D>> artifacts) {
        String[] anchors = new String[artifacts.size()];
        int i = 0;
        for (Artifact<D> artifact : artifacts) {
            anchors[i++] = artifact.getArtifactName() + ARTIFACT_ANCHOR_SUFFIX;
        }
        return anchors;
    }

    private void deployPackedDomains(String[] zips) {
        for (String zip : zips) {
            try {
                this.domainArchiveDeployer.deployPackagedArtifact(zip, Optional.empty());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void deleteAllAnchors() {
        this.deleteAnchorsFromDirectory(this.domainsDir);
        this.deleteAnchorsFromDirectory(this.appsDir);
    }

    private void deleteAnchorsFromDirectory(File directory) {
        String[] anchors;
        for (String anchor : anchors = DeploymentUtils.listFiles(directory, (FilenameFilter)new SuffixFileFilter(ARTIFACT_ANCHOR_SUFFIX))) {
            new File(directory, anchor).delete();
        }
    }

    private String[] removeDuplicateAppNames(String[] apps) {
        LinkedList<String> appNames = new LinkedList<String>();
        for (String appName : apps) {
            if (appNames.contains(appName)) continue;
            appNames.add(appName);
        }
        return appNames.toArray(new String[appNames.size()]);
    }

    private void redeployModifiedDomains() {
        Collection<String> redeployableDomains = this.getArtifactsToRedeploy(this.domains, this.domainTimestampListener);
        this.redeployModifiedArtifacts(redeployableDomains, this.domainArchiveDeployer);
    }

    private void redeployModifiedApplications() {
        Collection<String> redeployableApplications = this.getArtifactsToRedeploy(this.applications, this.applicationTimestampListener);
        this.redeployModifiedArtifacts(redeployableApplications, this.applicationArchiveDeployer);
    }

    private <D extends DeployableArtifactDescriptor, T extends DeployableArtifact<D>> Collection<String> getArtifactsToRedeploy(Collection<T> collection, ArtifactTimestampListener<T> artifactTimestampListener) {
        return collection.stream().filter(artifact -> artifact.getDescriptor().isRedeploymentEnabled()).filter(artifactTimestampListener::isArtifactResourceUpdated).map(Artifact::getArtifactName).collect(Collectors.toList());
    }

    private <D extends DeployableArtifactDescriptor, T extends Artifact<D>> void redeployModifiedArtifacts(Collection<String> artifactNames, ArchiveDeployer<D, T> artifactArchiveDeployer) {
        for (String artifactName : artifactNames) {
            try {
                artifactArchiveDeployer.redeploy(artifactName, Optional.empty());
            }
            catch (DeploymentException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Error redeploying artifact {}", (Object)artifactName, (Object)e);
            }
        }
    }

    private void stopAppDirMonitorTimer() {
        if (this.artifactDirMonitorScheduler != null) {
            this.artifactDirMonitorScheduler.shutdown();
            try {
                this.artifactDirMonitorScheduler.awaitTermination((long)DeploymentDirectoryWatcher.getChangesCheckIntervalMs(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setDoNotPersistStopStatusOfArtifacts() {
        for (Application application : this.applications) {
            this.applicationArchiveDeployer.doNotPersistArtifactStop(application);
        }
        for (Domain domain : this.domains) {
            this.domainArchiveDeployer.doNotPersistArtifactStop(domain);
        }
    }

    private static class ArtifactTimestampListener<T extends Artifact>
    implements PropertyChangeListener {
        private final Map<String, ArtifactResourcesTimestamp<T>> artifactConfigResourcesTimestaps = new HashMap<String, ArtifactResourcesTimestamp<T>>();

        public ArtifactTimestampListener(ObservableList<T> artifacts) {
            artifacts.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event instanceof ElementAddedEvent) {
                Artifact artifactAdded = (Artifact)event.getNewValue();
                this.artifactConfigResourcesTimestaps.put(artifactAdded.getArtifactName(), new ArtifactResourcesTimestamp(artifactAdded));
            } else if (event instanceof ElementRemovedEvent) {
                Artifact artifactRemoved = (Artifact)event.getNewValue();
                this.artifactConfigResourcesTimestaps.remove(artifactRemoved.getArtifactName());
            }
        }

        public boolean isArtifactResourceUpdated(T artifact) {
            ArtifactResourcesTimestamp<T> applicationResourcesTimestamp = this.artifactConfigResourcesTimestaps.get(artifact.getArtifactName());
            return !applicationResourcesTimestamp.resourcesHaveSameTimestamp();
        }
    }

    private static class ArtifactResourcesTimestamp<T extends Artifact> {
        private final Map<String, Long> timestampsPerResource = new HashMap<String, Long>();

        public ArtifactResourcesTimestamp(Artifact artifact) {
            for (File configResourceFile : artifact.getResourceFiles()) {
                this.timestampsPerResource.put(configResourceFile.getAbsolutePath(), configResourceFile.lastModified());
            }
            File descriptorFile = new File(((DeployableArtifactDescriptor)artifact.getDescriptor()).getArtifactLocation(), ArtifactDescriptor.MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION);
            if (descriptorFile.exists()) {
                this.timestampsPerResource.put(descriptorFile.getAbsolutePath(), descriptorFile.lastModified());
            }
        }

        public boolean resourcesHaveSameTimestamp() {
            return this.timestampsPerResource.entrySet().stream().noneMatch(entry -> {
                long currentTimestamp;
                File trackedFile = new File((String)entry.getKey());
                long originalTimestamp = (Long)entry.getValue();
                if (originalTimestamp != (currentTimestamp = trackedFile.lastModified())) {
                    this.timestampsPerResource.put((String)entry.getKey(), currentTimestamp);
                    return true;
                }
                return false;
            });
        }
    }
}

