/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;
import org.mule.runtime.module.artifact.internal.util.FileJarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JreExplorer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JreExplorer.class);
    private static Object bootLayer;
    private static Method getModulePackagesMethod;
    private static Method getLayerModulesMethod;
    private static boolean isRequiredReflectionDataPresent;
    private static final JarExplorer jarExplorer;

    private JreExplorer() {
    }

    public static void exploreJdk(Set<String> packages, Set<String> resources, List<ExportedService> services) {
        ArrayList<String> jdkPaths = new ArrayList<String>();
        JreExplorer.addJdkPath(jdkPaths, "sun.boot.class.path");
        JreExplorer.addJdkPath(jdkPaths, "java.ext.dirs");
        JreExplorer.addJdkPath(jdkPaths, "sun.boot.library.path");
        if (jdkPaths.isEmpty()) {
            LOGGER.warn("No JDK path/dir system property found. Defaulting to the whole classpath. This may cause classloading issues in some plugins.");
            jdkPaths.add(System.getProperty("java.class.path"));
        }
        JreExplorer.explorePaths(jdkPaths, packages, resources, services);
        JreExplorer.exploreJdkModules(packages);
    }

    private static void addJdkPath(List<String> jdkPaths, String key) {
        if (System.getProperties().containsKey(key)) {
            jdkPaths.add(System.getProperty(key));
        }
    }

    static void explorePaths(List<String> jdkPaths, Set<String> packages, Set<String> resources, List<ExportedService> services) {
        Preconditions.checkArgument((jdkPaths != null && !jdkPaths.isEmpty() ? 1 : 0) != 0, (String)"jdkPaths cannot be empty");
        for (String jdkPath : jdkPaths) {
            JreExplorer.explorePath(packages, resources, services, jdkPath);
        }
    }

    private static void exploreJdkModules(Set<String> packages) {
        if (isRequiredReflectionDataPresent) {
            try {
                Set modules = (Set)getLayerModulesMethod.invoke(bootLayer, new Object[0]);
                modules.stream().forEach(module -> {
                    try {
                        packages.addAll((Set)getModulePackagesMethod.invoke(module, new Object[0]));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error trying to get packages from JDK modules", e);
            }
        }
    }

    private static void explorePath(Set<String> packages, Set<String> resources, List<ExportedService> services, String jdkPath) {
        int endIndex;
        int fromIndex = 0;
        do {
            String item;
            File file;
            if ((file = new File(item = (endIndex = jdkPath.indexOf(File.pathSeparatorChar, fromIndex)) == -1 ? jdkPath.substring(fromIndex) : jdkPath.substring(fromIndex, endIndex))).exists()) {
                if (file.isDirectory()) {
                    JreExplorer.exploreDirectory(packages, resources, services, file);
                } else {
                    JarInfo exploredJar = jarExplorer.explore(file.toURI());
                    packages.addAll(exploredJar.getPackages());
                    resources.addAll(exploredJar.getResources());
                    services.addAll(exploredJar.getServices());
                }
            }
            fromIndex = endIndex + 1;
        } while (endIndex != -1);
    }

    private static void exploreDirectory(Set<String> packages, Set<String> resources, List<ExportedService> services, File file) {
        File[] content = file.listFiles();
        if (content == null) {
            return;
        }
        for (File entry : content) {
            if (!entry.exists()) continue;
            if (entry.isDirectory()) {
                JreExplorer.exploreDirectory(packages, resources, services, entry);
                continue;
            }
            if (!entry.getName().endsWith(".jar")) continue;
            JarInfo exploredJar = jarExplorer.explore(entry.toURI());
            packages.addAll(exploredJar.getPackages());
            resources.addAll(exploredJar.getResources());
            services.addAll(exploredJar.getServices());
        }
    }

    static {
        try {
            Class<?> moduleLayerClass = Class.forName("java.lang.ModuleLayer");
            Method getBootLayerMethod = moduleLayerClass.getDeclaredMethod("boot", new Class[0]);
            getLayerModulesMethod = moduleLayerClass.getDeclaredMethod("modules", new Class[0]);
            Class<?> moduleClass = Class.forName("java.lang.Module");
            getModulePackagesMethod = moduleClass.getDeclaredMethod("getPackages", new Class[0]);
            bootLayer = getBootLayerMethod.invoke(null, new Object[0]);
            isRequiredReflectionDataPresent = true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error found when trying to access to Java 9+ classes via reflection. If running with Java 8 or older this is the expected behaviour");
            }
            isRequiredReflectionDataPresent = false;
        }
        jarExplorer = new FileJarExplorer();
    }
}

