/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.core.util.PropertiesUtils;

public class ClasspathModuleDiscoverer
implements ModuleDiscoverer {
    public static final String MODULE_PROPERTIES = "META-INF/mule-module.properties";
    public static final String EXPORTED_CLASS_PACKAGES_PROPERTY = "artifact.export.classPackages";
    public static final String PRIVILEGED_EXPORTED_CLASS_PACKAGES_PROPERTY = "artifact.privileged.classPackages";
    public static final String PRIVILEGED_ARTIFACTS_PROPERTY = "artifact.privileged.artifacts";
    public static final String EXPORTED_RESOURCE_PROPERTY = "artifact.export.resources";
    private final ClassLoader classLoader;

    public ClasspathModuleDiscoverer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public List<MuleModule> discover() {
        LinkedList<MuleModule> modules = new LinkedList<MuleModule>();
        HashSet<String> moduleNames = new HashSet<String>();
        try {
            for (Properties moduleProperties : PropertiesUtils.discoverProperties((ClassLoader)this.classLoader, (String)MODULE_PROPERTIES)) {
                MuleModule module = this.createModule(moduleProperties);
                if (moduleNames.contains(module.getName())) {
                    throw new IllegalStateException(String.format("Module '%s' was already defined", module.getName()));
                }
                moduleNames.add(module.getName());
                modules.add(module);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot discover mule modules", e);
        }
        return modules;
    }

    private MuleModule createModule(Properties moduleProperties) {
        String moduleName = (String)moduleProperties.get("module.name");
        Set<String> modulePackages = this.getExportedPackageByProperty(moduleProperties, EXPORTED_CLASS_PACKAGES_PROPERTY);
        Set<String> modulePaths = this.getExportedResourcePaths(moduleProperties);
        Set<String> modulePrivilegedPackages = this.getExportedPackageByProperty(moduleProperties, PRIVILEGED_EXPORTED_CLASS_PACKAGES_PROPERTY);
        Set<String> privilegedArtifacts = this.getPrivilegedArtifactIds(moduleProperties);
        return new MuleModule(moduleName, modulePackages, modulePaths, modulePrivilegedPackages, privilegedArtifacts);
    }

    private Set<String> getPrivilegedArtifactIds(Properties moduleProperties) {
        String privilegedArtifactsProperty = (String)moduleProperties.get(PRIVILEGED_ARTIFACTS_PROPERTY);
        HashSet<String> artifactsIds = new HashSet<String>();
        if (!StringUtils.isEmpty((String)privilegedArtifactsProperty)) {
            for (String artifactName : privilegedArtifactsProperty.split(",")) {
                if (StringUtils.isEmpty((String)artifactName.trim())) continue;
                artifactsIds.add(artifactName);
            }
        }
        HashSet<String> privilegedArtifacts = artifactsIds;
        return privilegedArtifacts;
    }

    private Set<String> getExportedPackageByProperty(Properties moduleProperties, String privilegedExportedClassPackagesProperty) {
        String privilegedExportedPackagesProperty = (String)moduleProperties.get(privilegedExportedClassPackagesProperty);
        Set<String> modulePrivilegedPackages = !StringUtils.isEmpty((String)privilegedExportedPackagesProperty) ? this.getPackagesFromProperty(privilegedExportedPackagesProperty) : new HashSet<String>();
        return modulePrivilegedPackages;
    }

    private Set<String> getExportedResourcePaths(Properties moduleProperties) {
        HashSet<String> paths = new HashSet<String>();
        String exportedResourcesProperty = (String)moduleProperties.get(EXPORTED_RESOURCE_PROPERTY);
        if (!StringUtils.isEmpty((String)exportedResourcesProperty)) {
            for (String path : exportedResourcesProperty.split(",")) {
                if (StringUtils.isEmpty((String)path.trim())) continue;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                paths.add(path);
            }
        }
        return paths;
    }

    private Set<String> getPackagesFromProperty(String privilegedExportedPackagesProperty) {
        HashSet<String> packages = new HashSet<String>();
        for (String packageName : privilegedExportedPackagesProperty.split(",")) {
            if (StringUtils.isEmpty((String)(packageName = packageName.trim()))) continue;
            packages.add(packageName);
        }
        return packages;
    }
}

