/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.util;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.LoaderNotFoundException;
import org.mule.runtime.module.artifact.internal.util.ServiceRegistryDescriptorLoaderRepository;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Features(value={@Feature(value="Services"), @Feature(value="Descriptor loader")})
@Story(value="Service registry")
public class ServiceRegistryDescriptorLoaderRepositoryTestCase
extends AbstractMuleTestCase {
    private static final String LOADER_ID = "loader";
    private final ClassLoaderConfigurationLoader classLoaderConfigurationLoader = (ClassLoaderConfigurationLoader)Mockito.mock(ClassLoaderConfigurationLoader.class);
    private final Function<Class<? extends DescriptorLoader>, Stream<? extends DescriptorLoader>> serviceRegistry = ServiceRegistryDescriptorLoaderRepositoryTestCase.spyLambda(clazz -> Stream.of(this.classLoaderConfigurationLoader), Function.class);
    private final ServiceRegistryDescriptorLoaderRepository repository = new ServiceRegistryDescriptorLoaderRepository(this.serviceRegistry);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public static <R, G extends R> G spyLambda(G lambda, Class<R> lambdaType) {
        return (G)Mockito.mock(lambdaType, (Answer)AdditionalAnswers.delegatesTo(lambda));
    }

    @Test
    public void initializesClassLoaderConfigurationLoadersOnce() throws Exception {
        Mockito.when((Object)this.classLoaderConfigurationLoader.getId()).thenReturn((Object)LOADER_ID);
        Mockito.when((Object)this.classLoaderConfigurationLoader.supportsArtifactType(ArtifactType.PLUGIN)).thenReturn((Object)true);
        this.repository.get(LOADER_ID, ArtifactType.PLUGIN, ClassLoaderConfigurationLoader.class);
        this.repository.get(LOADER_ID, ArtifactType.PLUGIN, ClassLoaderConfigurationLoader.class);
        ((Function)Mockito.verify(this.serviceRegistry, (VerificationMode)Mockito.times((int)1))).apply(ClassLoaderConfigurationLoader.class);
        ((Function)Mockito.verify(this.serviceRegistry, (VerificationMode)Mockito.times((int)1))).apply(BundleDescriptorLoader.class);
    }

    @Test
    public void doesNotFindInvalidLoaderId() throws Exception {
        Mockito.when((Object)this.classLoaderConfigurationLoader.getId()).thenReturn((Object)LOADER_ID);
        this.expectedException.expect(LoaderNotFoundException.class);
        this.expectedException.expectMessage(ServiceRegistryDescriptorLoaderRepository.noRegisteredLoaderError((String)"invalid", ClassLoaderConfigurationLoader.class));
        this.repository.get("invalid", ArtifactType.PLUGIN, ClassLoaderConfigurationLoader.class);
    }

    @Test
    public void findsLoader() throws Exception {
        Mockito.when((Object)this.classLoaderConfigurationLoader.getId()).thenReturn((Object)LOADER_ID);
        Mockito.when((Object)this.classLoaderConfigurationLoader.supportsArtifactType(ArtifactType.PLUGIN)).thenReturn((Object)true);
        ClassLoaderConfigurationLoader classLoaderConfigurationLoader = (ClassLoaderConfigurationLoader)this.repository.get(LOADER_ID, ArtifactType.PLUGIN, ClassLoaderConfigurationLoader.class);
        MatcherAssert.assertThat((Object)classLoaderConfigurationLoader, (Matcher)Is.is((Object)classLoaderConfigurationLoader));
    }

    @Test
    public void findsLoaderIdWithType() throws Exception {
        Mockito.when((Object)this.classLoaderConfigurationLoader.getId()).thenReturn((Object)LOADER_ID);
        this.expectedException.expect(LoaderNotFoundException.class);
        this.expectedException.expectMessage(ServiceRegistryDescriptorLoaderRepository.noRegisteredLoaderError((String)LOADER_ID, BundleDescriptorLoader.class));
        this.repository.get(LOADER_ID, ArtifactType.PLUGIN, BundleDescriptorLoader.class);
    }
}

