/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Supplier;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidator;
import org.mule.runtime.module.artifact.internal.descriptor.CompositeArtifactDescriptorValidator;
import org.mule.runtime.module.artifact.internal.descriptor.MinMuleVersionArtifactDescriptorValidator;
import org.mule.runtime.module.artifact.internal.descriptor.MuleProductArtifactDescriptorValidator;
import org.mule.runtime.module.artifact.internal.descriptor.SupportedJvmArtifactDescriptorValidator;
import org.mule.runtime.module.artifact.internal.descriptor.VersionFormatArtifactDescriptorValidator;

public final class ArtifactDescriptorValidatorBuilder {
    private boolean minMuleVersionArtifactDescriptorValidator;
    private boolean validateMinMuleVersionWithSemanticVersioning;
    private Supplier<String> muleRuntimeVersionSupplier;
    private boolean validateMuleProduct;
    private boolean validateVersionFormat;
    private boolean doNotFailIfBundleDescriptorNotPresent;
    private boolean validateSupportedJavaVersions;

    private ArtifactDescriptorValidatorBuilder() {
    }

    public static ArtifactDescriptorValidatorBuilder builder() {
        return new ArtifactDescriptorValidatorBuilder();
    }

    public ArtifactDescriptorValidatorBuilder validateMinMuleVersion() {
        this.minMuleVersionArtifactDescriptorValidator = true;
        return this;
    }

    public ArtifactDescriptorValidatorBuilder validateMinMuleVersion(Supplier<String> muleRuntimeVersionSupplier) {
        this.validateMinMuleVersion();
        this.muleRuntimeVersionSupplier = muleRuntimeVersionSupplier;
        return this;
    }

    public ArtifactDescriptorValidatorBuilder validateMinMuleVersionUsingSemanticVersion() {
        this.validateMinMuleVersion();
        this.validateMinMuleVersionWithSemanticVersioning = true;
        return this;
    }

    public ArtifactDescriptorValidatorBuilder validateMuleProduct() {
        this.validateMuleProduct = true;
        return this;
    }

    public ArtifactDescriptorValidatorBuilder validateVersionFormat() {
        this.validateVersionFormat = true;
        return this;
    }

    public ArtifactDescriptorValidatorBuilder doNotFailIfBundleDescriptorNotPresentWhenValidationVersionFormat() {
        this.validateVersionFormat();
        this.doNotFailIfBundleDescriptorNotPresent = true;
        return this;
    }

    public ArtifactDescriptorValidatorBuilder validateSupportedJavaVersions() {
        this.validateSupportedJavaVersions = true;
        return this;
    }

    public ArtifactDescriptorValidator build() {
        ArrayList<ArtifactDescriptorValidator> validations = new ArrayList<ArtifactDescriptorValidator>();
        if (this.minMuleVersionArtifactDescriptorValidator) {
            if (this.muleRuntimeVersionSupplier != null) {
                validations.add(new MinMuleVersionArtifactDescriptorValidator(this.validateMinMuleVersionWithSemanticVersioning, this.muleRuntimeVersionSupplier));
            } else {
                validations.add(new MinMuleVersionArtifactDescriptorValidator(this.validateMinMuleVersionWithSemanticVersioning));
            }
        }
        if (this.validateMuleProduct) {
            validations.add(new MuleProductArtifactDescriptorValidator());
        }
        if (this.validateVersionFormat) {
            validations.add(new VersionFormatArtifactDescriptorValidator(this.doNotFailIfBundleDescriptorNotPresent));
        }
        if (this.validateSupportedJavaVersions) {
            validations.add(new SupportedJvmArtifactDescriptorValidator());
        }
        return new CompositeArtifactDescriptorValidator(Collections.unmodifiableList(validations));
    }
}

