/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;
import org.mule.runtime.module.artifact.activation.internal.classloader.NativeLibraryUnLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Java8NativeLibraryUnLoader
implements NativeLibraryUnLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Java8NativeLibraryUnLoader.class);
    public static final String NATIVE_LIBRARIES_FIELD = "nativeLibraries";
    public static final String FINALIZE_METHOD = "finalize";
    public static final String ERROR_ON_UNLOADING_NATIVE_LIBRARY_MESSAGE = "Error on unloading native library: ";

    @Override
    public void unloadNativeLibraries(ClassLoader classLoader) {
        try {
            Field field = ClassLoader.class.getDeclaredField(NATIVE_LIBRARIES_FIELD);
            field.setAccessible(true);
            Vector nativeLibraries = (Vector)field.get(classLoader);
            if (nativeLibraries != null) {
                nativeLibraries.forEach(nativeLibrary -> {
                    try {
                        Method finalizeMethod = nativeLibrary.getClass().getDeclaredMethod(FINALIZE_METHOD, new Class[0]);
                        finalizeMethod.setAccessible(true);
                        finalizeMethod.invoke(nativeLibrary, new Object[0]);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (Throwable e) {
            LOGGER.warn(ERROR_ON_UNLOADING_NATIVE_LIBRARY_MESSAGE, e);
        }
    }
}

