/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.deployable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Strings;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.utils.ArtifactUtils;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.utils.VersionUtils;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

public class DeployablePluginsDependenciesResolver {
    public final Map<BundleDescriptor, List<BundleDependency>> resolve(List<BundleDependency> deployableDependencies) {
        HashMap<BundleDescriptor, List<BundleDependency>> pluginsDependencies = new HashMap<BundleDescriptor, List<BundleDependency>>();
        List<BundleDependency> dependencies = deployableDependencies.stream().filter(dep -> dep.getDescriptor().getClassifier().isPresent()).filter(dep -> ArtifactType.PLUGIN.getMavenArtifactClassifier().equals(dep.getDescriptor().getClassifier().get())).collect(Collectors.toList());
        Map<BundleDependency, List<BundleDependency>> dependenciesMap = this.resolveDependencies(dependencies);
        for (Map.Entry<BundleDependency, List<BundleDependency>> dependencyListEntry : dependenciesMap.entrySet()) {
            List<BundleDependency> dependencyDependencies = this.resolveConflicts(dependencyListEntry.getValue(), dependencies);
            pluginsDependencies.put(dependencyListEntry.getKey().getDescriptor(), ArtifactUtils.updatePackagesResources(dependencyDependencies));
        }
        return pluginsDependencies;
    }

    private List<BundleDependency> resolveConflicts(List<BundleDependency> newDependencies, List<BundleDependency> alreadyResolved) {
        return this.resolveMulePluginsVersions(newDependencies, alreadyResolved);
    }

    public Map<BundleDependency, List<BundleDependency>> resolveDependencies(List<BundleDependency> mulePlugins) {
        LinkedHashMap<BundleDependency, List<BundleDependency>> muleDependenciesDependencies = new LinkedHashMap<BundleDependency, List<BundleDependency>>();
        for (BundleDependency muleDependency : mulePlugins) {
            muleDependenciesDependencies.put(muleDependency, this.collectTransitiveDependencies(muleDependency));
        }
        return muleDependenciesDependencies;
    }

    private List<BundleDependency> collectTransitiveDependencies(BundleDependency rootDependency) {
        LinkedList<BundleDependency> allTransitiveDependencies = new LinkedList<BundleDependency>();
        for (BundleDependency transitiveDependency : rootDependency.getTransitiveDependenciesList()) {
            allTransitiveDependencies.add(transitiveDependency);
            if (!transitiveDependency.getDescriptor().getClassifier().map(c -> !ArtifactType.PLUGIN.getMavenArtifactClassifier().equals(c)).orElse(true).booleanValue()) continue;
            allTransitiveDependencies.addAll(this.collectTransitiveDependencies(transitiveDependency));
        }
        return allTransitiveDependencies;
    }

    protected List<BundleDependency> resolveMulePluginsVersions(List<BundleDependency> mulePluginsToResolve, List<BundleDependency> definitiveMulePlugins) {
        ArrayList<BundleDependency> resolvedPlugins = new ArrayList<BundleDependency>();
        Preconditions.checkArgument((mulePluginsToResolve != null ? 1 : 0) != 0, (String)"List of mule plugins to resolve should not be null");
        Preconditions.checkArgument((definitiveMulePlugins != null ? 1 : 0) != 0, (String)"List of definitive mule plugins should not be null");
        for (BundleDependency mulePluginToResolve : mulePluginsToResolve) {
            Optional<BundleDependency> mulePlugin = definitiveMulePlugins.stream().filter(p -> this.hasSameArtifactIdAndMajor((BundleDependency)p, mulePluginToResolve)).findFirst();
            resolvedPlugins.add(mulePlugin.orElse(mulePluginToResolve));
        }
        return resolvedPlugins;
    }

    protected boolean hasSameArtifactIdAndMajor(BundleDependency bundleDependency, BundleDependency otherBundleDependency) {
        BundleDescriptor descriptor = bundleDependency.getDescriptor();
        BundleDescriptor otherDescriptor = otherBundleDependency.getDescriptor();
        return Strings.CS.equals((CharSequence)descriptor.getArtifactId(), (CharSequence)otherDescriptor.getArtifactId()) && Strings.CS.equals((CharSequence)VersionUtils.getMajor(descriptor.getBaseVersion()), (CharSequence)VersionUtils.getMajor(otherDescriptor.getBaseVersion()));
    }
}

