/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.nativelib;

import java.io.File;
import java.net.URL;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.activation.internal.nativelib.ArtifactCopyNativeLibraryFinder;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinderFactory;

public class DefaultNativeLibraryFinderFactory
implements NativeLibraryFinderFactory {
    private final Function<String, File> tempFolderChildFunction;

    public DefaultNativeLibraryFinderFactory() {
        this.tempFolderChildFunction = name -> MuleFoldersUtil.getAppDataFolder((String)name);
    }

    public DefaultNativeLibraryFinderFactory(Function<String, File> tempFolderChildFunction) {
        this.tempFolderChildFunction = tempFolderChildFunction;
    }

    @Override
    public NativeLibraryFinder create(String name, String folderName, URL[] urls) {
        MetadataTypeUtils.checkArgument((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"appName cannot be empty");
        Objects.requireNonNull(urls, "urls cannot be null");
        File tempFolder = new File(new File(this.tempFolderChildFunction.apply("native-libraries"), name), folderName);
        return new ArtifactCopyNativeLibraryFinder(tempFolder, urls);
    }
}

