/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.impl.util;

import java.util.ArrayDeque;
import java.util.Deque;
import org.mule.runtime.metrics.impl.util.StackElementFilter;

public class StackHasher {
    private final StackElementFilter filter;

    public StackHasher(StackElementFilter filter) {
        this.filter = filter;
    }

    public StackHasher() {
        this(StackElementFilter.withSourceInfo());
    }

    public String hexHash(Throwable error) {
        return this.toHex(this.hash(error, null));
    }

    public Deque<String> hexHashes(Throwable error) {
        ArrayDeque<String> hexHashes = new ArrayDeque<String>();
        this.hash(error, hexHashes);
        return hexHashes;
    }

    private int hash(Throwable error, Deque<String> hexHashes) {
        int hash = 0;
        if (error.getCause() != null && error.getCause() != error) {
            hash = this.hash(error.getCause(), hexHashes);
        }
        hash = 31 * hash + error.getClass().getName().hashCode();
        for (StackTraceElement element : error.getStackTrace()) {
            if (!this.filter.accept(element)) continue;
            hash = 31 * hash + this.hash(element);
        }
        if (hexHashes != null) {
            hexHashes.push(this.toHex(hash));
        }
        return hash;
    }

    private String toHex(int hash) {
        return String.format("%08x", hash);
    }

    private int hash(StackTraceElement element) {
        int result = element.getClassName().hashCode();
        result = 31 * result + element.getMethodName().hashCode();
        result = 31 * result + element.getLineNumber();
        return result;
    }
}

