/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.raml.internal.fragments.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public interface TypeDeclarationHandler {

  boolean handles(TypeDeclaration typeDeclaration);

  TypeBuilder<?> handle(TypeDeclaration typeDeclaration, BaseTypeBuilder root,
                        TypeDeclarationHandlerManager typeDeclarationHandlerManager, ParsingContext parsingContext);

}
