/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.api;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

/**
 * Interface to be implemented to extend the functionality of {@link MetadataType} serialization. The implementation of this class
 * is highly recommended when using the default logic for fallback a {@link TypeAnnotation} not found neither provided by
 * {@link TypeAnnotationSerializerExtender}. This implementations will be located using SPI. If no implementation is provided the
 * default mechanism that looks for a {@link Class} with the {@code annotationName} will be used.
 *
 * @since 1.0
 */
public interface TypeAnnotationSerializerExtenderFallback {

  /**
   * This method will allow to override {@link MetadataType} serialization to resolve the {@link Class} for a
   * {@link TypeAnnotation} by name in case if it was not already mapped in by {@link TypeAnnotationSerializerExtender}.
   *
   * @param annotationName the name of the {@link TypeAnnotation}.
   * @return a {@link Class} that represents the {@link TypeAnnotation} or {@link Optional#empty()} which means that the entry
   *         will be ignored and not added to the serialization output.
   */
  Optional<Class<? extends TypeAnnotation>> fallbackFor(String annotationName);

}
