/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence;

import static org.mule.metadata.api.model.MetadataFormat.CSV;
import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import static org.mule.metadata.api.model.MetadataFormat.JSON;
import static org.mule.metadata.api.model.MetadataFormat.XML;

import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

import java.util.Arrays;
import java.util.List;

/**
 * MetadataType Constants to help in the {@link MetadataType} serialization and deserialization
 *
 * @since 1.0
 */
public final class MetadataTypeConstants {

  // Type Names
  public static final String ANY = "Any";
  public static final String ARRAY = "Array";
  public static final String BINARY = "Binary";
  public static final String BOOLEAN = "Boolean";
  public static final String DATE_TIME = "DateTime";
  public static final String DATE = "Date";
  public static final String INTERSECTION = "Intersection";
  public static final String NULL = "Null";
  public static final String NOTHING = "Nothing";
  public static final String VOID = "Void";
  public static final String NUMBER = "Number";
  public static final String OBJECT = "Object";
  public static final String STRING = "String";
  public static final String TIME = "Time";
  public static final String TUPLE = "Tuple";
  public static final String FUNCTION = "Function";
  public static final String UNION = "Union";

  // Extras
  public static final String ANNOTATIONS = "annotations";
  public static final String ATTRIBUTES = "attributes";
  public static final String FIELDS = "fields";
  public static final String ITEM = "item";
  public static final String KEY = "key";
  public static final String REPEATED = "repeated";
  public static final String REQUIRED = "required";
  public static final String VALUE = "value";
  public static final String NAME = "name";
  public static final String ORDERED = "ordered";
  public static final String OPEN = "open";
  public static final String MODEL = "model";
  public static final String TYPE = "type";
  public static final String TYPE_ID = "typeId";
  public static final String RETURN_TYPE = "returnType";
  public static final String PARAMETERS = "parameters";
  public static final String RECURSION_FLAG = "#";
  public static final String REF_FLAG = "@ref:";
  public static final String FORMAT = "format";
  public static final String ID = "id";
  public static final String LABEL = "label";
  public static final String OF = "of";
  public static final String TRUE = "true";
  public static final String VALID_MIME_TYPES = "validMimeTypes";
  public static final String CATALOG = "catalog";

  /**
   * Common metadata formats
   */
  public static final List<MetadataFormat> commonMetadataFormats = Arrays.asList(JAVA, JSON, CSV, XML);

  private MetadataTypeConstants() {

  }
}
