/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.serializer;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Stack;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.serializer.BaseTypeSerializer;

public class TypeReferenceSerializer
extends BaseTypeSerializer<ObjectType> {
    private final ObjectTypeReferenceHandler handler;
    private final boolean formatOnReferences;

    TypeReferenceSerializer(ObjectTypeReferenceHandler handler, boolean formatOnReferences) {
        super("");
        this.handler = handler;
        this.formatOnReferences = formatOnReferences;
    }

    @Override
    public void serialize(JsonWriter writer, ObjectType type, Stack<MetadataType> typeStack) {
        try {
            writer.beginObject();
            if (this.formatOnReferences) {
                this.writeMetadataFormat(writer, (MetadataType)type, typeStack);
            }
            this.doSerialize(writer, type, typeStack);
            writer.endObject();
        }
        catch (IOException e) {
            throw new MetadataSerializingException("ObjectType reference", e);
        }
    }

    @Override
    protected void doSerialize(JsonWriter writer, ObjectType type, Stack<MetadataType> typeStack) {
        this.handler.writeReference(type, writer);
    }
}

