/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.reduced;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;

public class InnerCatalogObjectTypeReferenceHandler
implements ObjectTypeReferenceHandler {
    private final Map<String, MetadataType> catalog;

    InnerCatalogObjectTypeReferenceHandler() {
        this.catalog = Collections.emptyMap();
    }

    InnerCatalogObjectTypeReferenceHandler(Map<String, MetadataType> catalog) {
        this.catalog = catalog;
    }

    @Override
    public Optional<TypeBuilder> readReference(String typeReference) {
        if (typeReference.startsWith("@ref:")) {
            return Optional.of(() -> this.catalog.get(typeReference.replace("@ref:", "")));
        }
        return Optional.empty();
    }

    @Override
    public boolean shouldWriteReference(ObjectType type) {
        return MetadataTypeUtils.getTypeId((MetadataType)type).isPresent();
    }

    @Override
    public Optional<String> writeReference(ObjectType type, JsonWriter writer) {
        Optional typeId = MetadataTypeUtils.getTypeId((MetadataType)type);
        if (typeId.isPresent()) {
            try {
                writer.name("type").value("@ref:" + (String)typeId.get());
            }
            catch (IOException e) {
                throw new MetadataSerializingException("MetadataType reference [" + (String)typeId.get() + "]", e);
            }
        }
        return typeId;
    }
}

