/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.deserializer;

import static org.mule.metadata.persistence.MetadataTypeConstants.ITEM;
import static org.mule.metadata.persistence.deserializer.SerializerUtils.VOLATILE_FORMAT;

import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;

import com.google.gson.JsonObject;

/**
 * {@link TypeDeserializer} implementation that deserializes an {@link ArrayType} and returns an {@link ArrayTypeBuilder}
 *
 * @since 1.0
 */
final class ArrayTypeDeserializer extends AbstractTypeDeserializer {

  ArrayTypeDeserializer() {
    super(BaseTypeBuilder::arrayType);
  }

  @Override
  public TypeBuilder buildType(JsonObject typeObject, BaseTypeBuilder baseBuilder, JsonMetadataTypeLoader typeLoader) {
    final ArrayTypeBuilder arrayTypeBuilder = (ArrayTypeBuilder) supplier.get(baseBuilder);
    arrayTypeBuilder.of(typeLoader.buildType(typeObject.get(ITEM), new BaseTypeBuilder(VOLATILE_FORMAT)));
    parseAnnotations(typeObject, arrayTypeBuilder);
    return arrayTypeBuilder;
  }
}
