/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api.handler;

import java.util.Collection;
import java.util.stream.Collectors;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.IntersectionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.json.api.handler.HandlerManager;
import org.mule.metadata.json.api.handler.ParsingContext;
import org.mule.metadata.json.api.handler.SchemaHandler;

public class CombinedHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof CombinedSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, HandlerManager handlerManager, ParsingContext parsingContext) {
        CombinedSchema combinedSchema = (CombinedSchema)schema;
        Collection subschemas = combinedSchema.getSubschemas();
        if (subschemas.stream().anyMatch(subSchema -> subSchema instanceof EnumSchema)) {
            subschemas = subschemas.stream().filter(subSchema -> !(subSchema instanceof StringSchema)).collect(Collectors.toList());
        }
        if (subschemas.size() == 1) {
            return handlerManager.handle((Schema)subschemas.iterator().next(), parsingContext);
        }
        if (combinedSchema.getCriterion() == CombinedSchema.ANY_CRITERION || combinedSchema.getCriterion() == CombinedSchema.ONE_CRITERION) {
            UnionTypeBuilder unionType = root.unionType();
            for (Schema subschema : subschemas) {
                unionType.of(handlerManager.handle(subschema, parsingContext));
            }
            return unionType;
        }
        if (combinedSchema.getCriterion() == CombinedSchema.ALL_CRITERION) {
            IntersectionTypeBuilder intersectionType = root.intersectionType();
            for (Schema subschema : subschemas) {
                intersectionType.of(handlerManager.handle(subschema, parsingContext));
            }
            return intersectionType;
        }
        return root.anyType();
    }
}

