/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.api.handler;

import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.IntersectionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;

import java.util.Collection;

public class CombinedHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof CombinedSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, HandlerManager handlerManager,
                               ParsingContext parsingContext) {
    final CombinedSchema combinedSchema = (CombinedSchema) schema;
    final Collection<Schema> subschemas = combinedSchema.getSubschemas();
    if (combinedSchema.getCriterion() == CombinedSchema.ANY_CRITERION
        || combinedSchema.getCriterion() == CombinedSchema.ONE_CRITERION) {
      final UnionTypeBuilder unionType = root.unionType();
      for (Schema subschema : subschemas) {
        unionType.of(handlerManager.handle(subschema, parsingContext));
      }
      return unionType;
    } else if (combinedSchema.getCriterion() == CombinedSchema.ALL_CRITERION) {
      final IntersectionTypeBuilder intersectionType = root.intersectionType();
      for (Schema subschema : subschemas) {
        intersectionType.of(handlerManager.handle(subschema, parsingContext));
      }
      return intersectionType;
    }
    return root.anyType();
  }
}
