/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.api.handler;

import static org.mule.metadata.internal.utils.StringUtils.isNotEmpty;

import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TupleTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;

public class ReferenceHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof ReferenceSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, HandlerManager handlerManager,
                               ParsingContext parsingContext) {
    final Schema referredSchema = ((ReferenceSchema) schema).getReferredSchema();
    final TypeBuilder<?> referenceType = handlerManager.handle(referredSchema, parsingContext);

    final String title = schema.getTitle();
    if (isNotEmpty(title)) {
      if (referenceType instanceof ArrayTypeBuilder) {
        ((ArrayTypeBuilder) referenceType).label(title);
      } else if (referenceType instanceof TupleTypeBuilder) {
        ((TupleTypeBuilder) referenceType).label(title);
      } else if (referenceType instanceof ObjectTypeBuilder) {
        ((ObjectTypeBuilder) referenceType).label(title);
      } else if (referenceType instanceof ObjectFieldTypeBuilder) {
        ((ObjectFieldTypeBuilder) referenceType).label(title);
      }
    }

    return referenceType;
  }
}
