/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.api.example;

import static java.util.Objects.requireNonNull;

import org.mule.metadata.api.annotation.TypeAnnotation;

import java.util.ArrayList;
import java.util.List;

public class ParsingContext {

  private final HandlerConfiguration handlerConfiguration;

  private final List<TypeAnnotation> annotations = new ArrayList<>();

  public ParsingContext(HandlerConfiguration handlerConfiguration) {
    requireNonNull(handlerConfiguration);
    this.handlerConfiguration = handlerConfiguration;
  }

  public HandlerConfiguration getHandlerConfiguration() {
    return handlerConfiguration;
  }

  public List<TypeAnnotation> getAnnotations() {
    return annotations;
  }

  public ParsingContext withAnnotation(TypeAnnotation annotation) {
    this.annotations.add(annotation);
    return this;
  }
}
