/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.handler;

import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import java.util.Set;

public class EnumHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof EnumSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, HandlerManager handlerManager,
                               ParsingContext parsingContext) {
    final EnumSchema enumSchema = (EnumSchema) schema;
    final StringTypeBuilder enumMetadataBuilder = root.stringType();
    final Set<Object> possibleValues = enumSchema.getPossibleValues();
    final String[] stringValues = possibleValues.stream().map((v) -> String.valueOf(v)).toArray(String[]::new);
    enumMetadataBuilder.enumOf(stringValues);
    return enumMetadataBuilder;
  }
}
