/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.example;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import com.google.gson.JsonElement;

public class NullHandler implements JsonElementHandler {

  @Override
  public boolean handles(JsonElement jsonElement) {
    return jsonElement.isJsonNull();
  }

  @Override
  public TypeBuilder<?> handle(JsonElement jsonElement, BaseTypeBuilder root, HandlerManager handlerManager,
                               ParsingContext parsingContext) {
    return root.nullType();
  }
}
