/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.annotation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.metadata.annotation.pojo.InstantiableClass;
import org.mule.metadata.annotation.pojo.MultipleConstructor;
import org.mule.metadata.annotation.pojo.NoDefaultConstructor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;

public class ClassInformationAnnotationTestCase {
    private ClassInformationAnnotation annotation;

    @Test
    public void isFinalClass() {
        this.annotation = new ClassInformationAnnotation(InstantiableClass.class, null);
        MatcherAssert.assertThat((Object)this.annotation.isFinal(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void isAbstractClass() {
        this.annotation = new ClassInformationAnnotation(AbstractClass.class, null);
        MatcherAssert.assertThat((Object)this.annotation.isAbstract(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.annotation.isInstantiable(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void isInterface() {
        this.annotation = new ClassInformationAnnotation(Interface.class, null);
        MatcherAssert.assertThat((Object)this.annotation.isInterface(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.annotation.isInstantiable(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void isMap() {
        this.annotation = new ClassInformationAnnotation(CustomMap.class, null);
        MatcherAssert.assertThat((Object)this.annotation.isMap(), (Matcher)Is.is((Object)true));
        this.annotation = new ClassInformationAnnotation(InstantiableClass.class, null);
        MatcherAssert.assertThat((Object)this.annotation.isMap(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void hasDefaultConstructor() {
        this.annotation = new ClassInformationAnnotation(InstantiableClass.class, null);
        MatcherAssert.assertThat((Object)this.annotation.isInstantiable(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.annotation.hasDefaultConstructor(), (Matcher)Is.is((Object)true));
        this.annotation = new ClassInformationAnnotation(MultipleConstructor.class, null);
        MatcherAssert.assertThat((Object)this.annotation.isInstantiable(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.annotation.hasDefaultConstructor(), (Matcher)Is.is((Object)true));
        this.annotation = new ClassInformationAnnotation(NoDefaultConstructor.class, null);
        MatcherAssert.assertThat((Object)this.annotation.isInstantiable(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.annotation.hasDefaultConstructor(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void getParent() {
        this.annotation = new ClassInformationAnnotation(WithParent.class, null);
        MatcherAssert.assertThat((Object)this.annotation.getParent().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(this.annotation.getParent().get(), (Matcher)Is.is((Object)AbstractClass.class.getName()));
    }

    @Test
    public void getImplementedInterfaces() {
        this.annotation = new ClassInformationAnnotation(Interface.class, null);
        MatcherAssert.assertThat((Object)this.annotation.getImplementedInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{Serializable.class.getName(), Cloneable.class.getName()}));
        this.annotation = new ClassInformationAnnotation(NoDefaultConstructor.class, null);
        MatcherAssert.assertThat((Object)this.annotation.getImplementedInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{Serializable.class.getName(), Cloneable.class.getName()}));
    }

    @Test
    public void getGenerics() {
        this.annotation = new ClassInformationAnnotation(Object.class, Collections.singletonList(String.class));
        MatcherAssert.assertThat((Object)this.annotation.getGenericTypes(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.annotation.getGenericTypes().get(0), (Matcher)Is.is((Object)String.class.getName()));
        this.annotation = new ClassInformationAnnotation(Object.class, Arrays.asList(String.class, Object.class));
        MatcherAssert.assertThat((Object)this.annotation.getGenericTypes(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)this.annotation.getGenericTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{String.class.getName(), Object.class.getName()}));
    }

    private static class CustomMap
    implements Map {
        private CustomMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        public Object get(Object key) {
            return null;
        }

        public Object put(Object key, Object value) {
            return null;
        }

        public Object remove(Object key) {
            return null;
        }

        public void putAll(Map m) {
        }

        @Override
        public void clear() {
        }

        public Set keySet() {
            return null;
        }

        public Collection values() {
            return null;
        }

        public Set<Map.Entry> entrySet() {
            return null;
        }
    }

    private static interface Interface
    extends Cloneable,
    Serializable {
    }

    private static class WithParent
    extends AbstractClass {
        private WithParent() {
        }
    }

    private static abstract class AbstractClass {
        private AbstractClass() {
        }
    }
}

