/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.api.utils;

import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;

import java.util.Optional;

import org.apache.commons.lang3.ClassUtils;

public final class JavaTypeUtils {

  private JavaTypeUtils() {}

  public static Optional<String> getId(MetadataType metadataType) {
    Optional<String> id = MetadataTypeUtils.getTypeId(metadataType);
    if (id.isPresent()) {
      return id;
    }

    ClassNameResolverVisitor visitor = new ClassNameResolverVisitor();
    metadataType.accept(visitor);
    return visitor.getTypeName();
  }

  public static <T> Class<T> getType(MetadataType metadataType) {
    return getType(metadataType, Thread.currentThread().getContextClassLoader());
  }

  public static <T> Class<T> getType(MetadataType metadataType, ClassLoader classLoader) {
    ClassNameResolverVisitor visitor = new ClassNameResolverVisitor();
    metadataType.accept(visitor);
    String className = visitor.getTypeName().orElse(null);
    if (className != null) {
      try {
        return (Class<T>) ClassUtils.getClass(classLoader, className, true);
      } catch (ClassNotFoundException e) {
        throw new IllegalArgumentException("Could not load class [" + className + "]", e);
      }
    }
    throw new IllegalArgumentException("Could not find class for MetadataType [" + metadataType + "]");
  }

  @Deprecated
  public static Optional<MetadataType> getGenericTypeAt(MetadataType metadataType, int index, ClassTypeLoader typeLoader) {
    Optional<ClassInformationAnnotation> classInformationAnnotation =
        metadataType.getAnnotation(ClassInformationAnnotation.class);
    if (!classInformationAnnotation.isPresent() || classInformationAnnotation.get().getGenericTypes().size() <= index) {
      return Optional.empty();
    }
    return typeLoader.load(classInformationAnnotation.get().getGenericTypes().get(index));
  }
}
