/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.internal.utils;

import org.mule.metadata.java.api.utils.ParsingContext;

/**
 * Provides an isolated context that can be retrieved at any time from its parent context.
 *
 * @since 1.9
 */
public class ParsingSubContext extends ParsingContext {

  private final String subId;
  private final ParsingContext parent;

  public ParsingSubContext(String subId, ParsingContext parent) {
    this.subId = subId;
    this.parent = parent;
  }

  @Override
  public ParsingContext getSubContext(String subId) {
    if (this.subId.equals(subId)) {
      return this;
    } else {
      return parent.getSubContext(subId);
    }
  }

}
