/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.api.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.ParsingContext;

import java.lang.reflect.Type;
import java.util.List;

public class ObjectHandler implements ClassHandler {

  private final ObjectFieldHandler fieldHandler;

  public ObjectHandler(ObjectFieldHandler fieldHandler) {
    this.fieldHandler = fieldHandler;
  }

  @Override
  public boolean handles(Class<?> clazz) {
    return true;
  }

  @Override
  public TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager,
                                    ParsingContext context, BaseTypeBuilder typeBuilder) {
    final ObjectTypeBuilder objectType = typeBuilder.objectType();

    context.addTypeBuilder(clazz, objectType);
    fieldHandler.handleFields(clazz, typeHandlerManager, context, objectType);
    if (clazz.getCanonicalName() != null) {
      objectType.id(clazz.getCanonicalName());
    }

    objectType.with(new ClassInformationAnnotation(clazz, genericTypes));
    return objectType;
  }
}
