/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.api.utils;

import static java.util.Optional.ofNullable;

import org.mule.metadata.api.builder.TypeBuilder;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;

/**
 * Keeps contexts for type loading from java classes that is valid for all the types form an extension.
 */
public class ExtensionParsingContext {

  private final Map<Type, TypeBuilder<?>> typedObjects = new WeakHashMap<>();

  public Optional<TypeBuilder<?>> getTypeBuilder(Type type) {
    return ofNullable(typedObjects.get(type));
  }

  public void addTypeBuilder(Type type, TypeBuilder<?> typedObject) {
    if (!typedObjects.containsKey(type)) {
      typedObjects.put(type, typedObject);
    }
  }

}
