/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.internal;

import java.util.Comparator;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeVisitor;
import org.mule.metadata.api.annotation.Accessibility;
import org.mule.metadata.api.annotation.AccessibilityAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.api.ObjectFieldHandler;
import org.mule.metadata.ast.api.Property;
import org.mule.metadata.ast.api.TypeUtils;

public final class DefaultObjectFieldHandler
implements ObjectFieldHandler {
    private ProcessingEnvironment processingEnvironment;

    public DefaultObjectFieldHandler(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    @Override
    public void handle(Element element, ObjectTypeBuilder objectTypeBuilder, IntrospectionContext context, TypeVisitor<TypeBuilder<?>, IntrospectionContext> typeVisitor) {
        TypeUtils.getProperties(element, this.processingEnvironment).stream().sorted(Comparator.comparing(Property::getBeanName)).forEach(property -> {
            ObjectFieldTypeBuilder fieldTypeBuilder = objectTypeBuilder.addField().key(property.getBeanName());
            Element propertyElement = this.processingEnvironment.getTypeUtils().asElement(property.getType());
            if (context.contains(propertyElement)) {
                fieldTypeBuilder.value(context.get(propertyElement));
            } else {
                fieldTypeBuilder.value((TypeBuilder)property.getType().accept(typeVisitor, context));
            }
            this.addAccessibilityProperty(fieldTypeBuilder, property.getGetterMethod() != null, property.getSetterMethod() != null);
        });
    }

    private void addAccessibilityProperty(ObjectFieldTypeBuilder fieldTypeBuilder, boolean hasGetter, boolean hasSetter) {
        if (hasGetter && !hasSetter) {
            fieldTypeBuilder.with((TypeAnnotation)new AccessibilityAnnotation(Accessibility.READ_ONLY));
        }
        if (!hasGetter && hasSetter) {
            fieldTypeBuilder.with((TypeAnnotation)new AccessibilityAnnotation(Accessibility.WRITE_ONLY));
        }
    }
}

