/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.internal.handler;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.internal.ClassInformationAnnotationFactory;
import org.mule.metadata.ast.internal.handler.BaseTypeHandler;

public class ArrayTypeHandler
extends BaseTypeHandler {
    public ArrayTypeHandler(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment, Collection.class, Iterable.class, Iterator.class);
    }

    @Override
    public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> visitor, IntrospectionContext context) {
        if (this.astHelper.isAssignable(typeMirror, Collection.class, Iterable.class, Iterator.class)) {
            ArrayTypeBuilder arrayTypeBuilder = this.builder().arrayType().with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(typeMirror, this.processingEnvironment));
            List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
            if (typeArguments.isEmpty()) {
                arrayTypeBuilder.of(this.objectType.accept(visitor, context));
            } else {
                arrayTypeBuilder.of(typeArguments.get(0).accept(visitor, context));
            }
            return arrayTypeBuilder;
        }
        throw new IllegalArgumentException("The given TypeMirror is not handleable. " + typeMirror);
    }
}

