/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.ast.api;

import org.mule.metadata.api.builder.TypeBuilder;

import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;

/**
 * Handler for AST Types
 *
 * @since 1.1.0
 */
public interface TypeHandler {

  /**
   * @return a boolean indicating if this {@link TypeHandler} supports the given {@link TypeMirror}
   */
  boolean handles(TypeMirror typeMirror);

  /**
   * Handles a given {@link TypeMirror} and returns the correspondent {@link TypeBuilder}
   *
   * @param typeMirror Type to introspect
   * @param delegate   Delegate visitor
   * @param context    Current context with already introspected types.
   * @return The {@link TypeBuilder} representation of the given {@link TypeMirror}
   */
  TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> delegate,
                        IntrospectionContext context);
}
