/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.ast.internal.handler;

import static org.mule.metadata.ast.internal.ASTHelper.typeId;

import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.ast.api.TypeHandler;
import org.mule.metadata.ast.api.IntrospectionContext;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;

/**
 * {@link TypeHandler} for {@link Boolean boolean types}
 *
 * @since 1.1.0
 */
public class BooleanTypeHandler extends BaseTypeHandler {

  public BooleanTypeHandler(ProcessingEnvironment processingEnvironment) {
    super(processingEnvironment, Boolean.class);
  }

  @Override
  public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> visitor,
                               IntrospectionContext context) {
    if (astHelper.isAssignable(typeMirror, Boolean.class)) {
      return builder().booleanType().id(typeId((DeclaredType) typeMirror));
    }

    throw new IllegalArgumentException("The given TypeMirror is not handleable. " + typeMirror);
  }
}
