/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.ast.api;

import org.mule.metadata.api.builder.TypeBuilder;

import java.util.Stack;

import javax.lang.model.element.Element;

/**
 * Context where the information of already introspected types are save temporally. This is used to prevent infinite introspection
 * in recursive types.
 *
 * @since 1.1.0
 */
public final class IntrospectionContext {

  private Stack<Element> elements = new Stack<>();
  private Stack<TypeBuilder> typeBuilders = new Stack<>();

  public void push(Element element, TypeBuilder typeBuilder) {
    elements.push(element);
    typeBuilders.push(typeBuilder);
  }

  public TypeBuilder pop() {
    elements.pop();
    return typeBuilders.pop();
  }

  public boolean contains(Element element) {
    return elements.contains(element);
  }

  public TypeBuilder get(Element element) {
    return typeBuilders.get(elements.indexOf(element));
  }
}
