/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.catalog.internal.model.loaders.shape;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.catalog.internal.model.loaders.TypeLoaderFactory;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;

import java.io.File;
import java.net.URI;

public class XmlSchemaTypeLoaderFactory implements TypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return "application/xml";
  }

  @Override
  public String getLoaderFormat() {
    return "application/xml+schema";
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    final SchemaCollector schemaCollector = SchemaCollector.getInstance().addSchema(file);
    return new XmlTypeLoader(schemaCollector);
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    final SchemaCollector schemaCollector = SchemaCollector.getInstance().addSchema("", content);
    return new XmlTypeLoader(schemaCollector);
  }

  @Override
  public TypeLoader createTypeLoader(String content, URI uri) {
    final SchemaCollector schemaCollector = SchemaCollector.getInstance().addSchema(uri.toString(), content);
    return new XmlTypeLoader(schemaCollector);
  }
}
