/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.catalog.internal.model.loaders.shape;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.catalog.internal.model.loaders.TypeLoaderFactory;
import org.mule.metadata.java.api.JavaTypeLoader;

import java.io.File;

public class JavaTypeLoaderFactory implements TypeLoaderFactory {

  private final ClassLoader classLoader;

  public JavaTypeLoaderFactory(ClassLoader classLoader) {
    this.classLoader = classLoader;
  }

  @Override
  public String getTypeFormat() {
    return "application/java";
  }

  @Override
  public String getLoaderFormat() {
    return "application/classloader";
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new JavaTypeLoader(classLoader);
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new JavaTypeLoader(classLoader);
  }
}
