/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.catalog.internal.model.loaders.shape;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.catalog.internal.model.loaders.TypeLoaderFactory;
import org.mule.metadata.raml.api.map.MapTypeLoader;

import java.io.File;

public class MapTypeLoaderFactory implements TypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return "application/java";
  }

  @Override
  public String getLoaderFormat() {
    return "application/raml+yaml";
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new MapTypeLoader(file);
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new MapTypeLoader(content, "");
  }

}
