/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

public class DefaultFunctionType
extends BaseMetadataType
implements FunctionType {
    private final Optional<MetadataType> returnType;
    private final List<FunctionParameter> parameters;
    private Object[] fieldValues;

    public DefaultFunctionType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations, Optional<MetadataType> returnType, List<FunctionParameter> parameters) {
        super(metadataFormat, annotations);
        this.returnType = returnType;
        this.parameters = parameters;
    }

    @Override
    public Object[] getFieldValues() {
        if (this.fieldValues == null) {
            this.fieldValues = this.createFieldValuesArray();
        }
        return this.fieldValues;
    }

    private Object[] createFieldValuesArray() {
        ArrayList fieldValues = new ArrayList();
        Collections.addAll(fieldValues, super.getFieldValues());
        Collections.addAll(fieldValues, this.returnType, this.parameters);
        return fieldValues.toArray(new Object[fieldValues.size()]);
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Optional<MetadataType> getReturnType() {
        return this.returnType;
    }

    @Override
    public void accept(MetadataTypeVisitor visitor) {
        visitor.visitFunction(this);
    }
}

