/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.internal.utils;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.metadata.api.model.FieldsComparable;
import org.mule.metadata.internal.utils.IDKey;

public class EfficientEquals {
    private static final ThreadLocal<Set<Pair<IDKey, IDKey>>> EQUALS_REGISTRY = new ThreadLocal();

    static Set<Pair<IDKey, IDKey>> getRegistry() {
        return EQUALS_REGISTRY.get();
    }

    static Pair<IDKey, IDKey> getRegisterPair(Object lhs, Object rhs) {
        IDKey left = new IDKey(lhs);
        IDKey right = new IDKey(rhs);
        return Pair.of((Object)left, (Object)right);
    }

    static boolean isRegistered(Object lhs, Object rhs) {
        Set<Pair<IDKey, IDKey>> registry = EfficientEquals.getRegistry();
        Pair<IDKey, IDKey> pair = EfficientEquals.getRegisterPair(lhs, rhs);
        Pair swappedPair = Pair.of((Object)((IDKey)pair.getRight()), (Object)((IDKey)pair.getLeft()));
        return registry != null && (registry.contains(pair) || registry.contains(swappedPair));
    }

    private static void register(Object lhs, Object rhs) {
        Set<Pair<IDKey, IDKey>> registry = EfficientEquals.getRegistry();
        if (registry == null) {
            registry = new HashSet<Pair<IDKey, IDKey>>();
            EQUALS_REGISTRY.set(registry);
        }
        Pair<IDKey, IDKey> pair = EfficientEquals.getRegisterPair(lhs, rhs);
        registry.add(pair);
    }

    private static void unregister(Object lhs, Object rhs) {
        Set<Pair<IDKey, IDKey>> registry = EfficientEquals.getRegistry();
        if (registry != null) {
            Pair<IDKey, IDKey> pair = EfficientEquals.getRegisterPair(lhs, rhs);
            registry.remove(pair);
            if (registry.isEmpty()) {
                EQUALS_REGISTRY.remove();
            }
        }
    }

    private EfficientEquals() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean efficientEquals(FieldsComparable thisObj, FieldsComparable thatObj) {
        if (EfficientEquals.isRegistered(thisObj, thatObj)) {
            return true;
        }
        try {
            EfficientEquals.register(thisObj, thatObj);
            Object[] theseFields = thisObj.getFieldValues();
            Object[] thoseFields = thatObj.getFieldValues();
            for (int i = 0; i < thoseFields.length; ++i) {
                Object thisField = theseFields[i];
                Object thatField = thoseFields[i];
                if (thisField == thatField) continue;
                if (thisField == null) {
                    boolean bl = false;
                    return bl;
                }
                if (thisField.equals(thatField)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            EfficientEquals.unregister(thisObj, thatObj);
        }
    }
}

