/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import static java.util.Optional.ofNullable;

import org.mule.metadata.api.utils.MetadataTypeUtils;

import java.util.Objects;
import java.util.Optional;

/**
 * Constrain for number specifying the range where this number is valid.
 */
public class NumberRangeAnnotation implements TypeAnnotation {

  public static final String NAME = "range";
  private final Number from;
  private final Number to;

  public NumberRangeAnnotation(Number from, Number to) {
    this.from = from;
    this.to = to;
  }

  public Optional<Number> getFrom() {
    return ofNullable(from);
  }

  public Optional<Number> getTo() {
    return ofNullable(to);
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof NumberRangeAnnotation) {
      NumberRangeAnnotation other = (NumberRangeAnnotation) obj;
      return Objects.equals(getFrom(), other.getFrom()) && Objects.equals(getTo(), other.getTo());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return MetadataTypeUtils.hashCode(getFrom(), getTo());
  }
}
