/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import static java.util.Collections.addAll;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultObjectFieldType extends BaseMetadataType implements ObjectFieldType {

  private final ObjectKeyType key;
  private final MetadataType value;
  private final boolean isRequired;
  private final boolean isRepeated;
  private Object[] fieldValues;

  public DefaultObjectFieldType(ObjectKeyType key, MetadataType value, boolean isRequired, boolean isRepeated,
                                MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
    super(metadataFormat, annotations);
    this.key = key;
    this.value = value;
    this.isRequired = isRequired;
    this.isRepeated = isRepeated;
  }

  @Override
  public Object[] getFieldValues() {
    if (fieldValues == null) {
      fieldValues = createFieldValuesArray();
    }
    return fieldValues;
  }

  private Object[] createFieldValuesArray() {
    List<Object> fieldValues = new ArrayList<>();
    addAll(fieldValues, super.getFieldValues());
    addAll(fieldValues, key, value, isRepeated, isRequired);
    return fieldValues.toArray(new Object[fieldValues.size()]);
  }

  @Override
  public ObjectKeyType getKey() {
    return key;
  }

  @Override
  public MetadataType getValue() {
    return value;
  }

  @Override
  public boolean isRequired() {
    return isRequired;
  }

  @Override
  public boolean isRepeated() {
    return isRepeated;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitObjectField(this);
  }
}
