/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;


import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Map;

public class DefaultNothingType extends BaseMetadataType implements NothingType {

  public DefaultNothingType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
    super(metadataFormat, annotations);
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitNothing(this);
  }
}
