/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

import java.util.List;

/**
 * For any types X and Y, the union, or disjunction, X|Y, of the types may be formed. A union type is a supertype of both of the
 * given types X and Y, and an instance of either type is an instance of the union type.
 * <p>
 * Note: the type expression X|Y is pronounced “x or y”.
 * <p>
 */
public interface UnionType extends MetadataType {

  /**
   * The list of types that belongs to this union.
   *
   * @return The list of types
   */
  List<MetadataType> getTypes();
}
