/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractBuilder<T extends MetadataType> implements TypeBuilder<T> {

  protected final Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations = new LinkedHashMap<>();
  protected final MetadataFormat format;

  protected AbstractBuilder(MetadataFormat format) {
    if (format == null) {
      throw new IllegalArgumentException("format cannot be null");
    }
    this.format = format;
  }

  protected void addExtension(TypeAnnotation extension) {
    if (this.annotations.containsKey(extension.getClass())) {
      throw new IllegalArgumentException(String.format("an annotation of type '%s' is already defined", extension.getClass()));
    }
    annotations.put(extension.getClass(), extension);
  }

}
